/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mobile.DefaultMobileBaseClientBuilder;
import software.amazon.awssdk.services.mobile.DefaultMobileClient;
import software.amazon.awssdk.services.mobile.MobileClient;
import software.amazon.awssdk.services.mobile.MobileClientBuilder;
import software.amazon.awssdk.services.mobile.MobileServiceClientConfiguration;
import software.amazon.awssdk.services.mobile.endpoints.MobileEndpointProvider;

@SdkInternalApi
final class DefaultMobileClientBuilder
extends DefaultMobileBaseClientBuilder<MobileClientBuilder, MobileClient>
implements MobileClientBuilder {
    DefaultMobileClientBuilder() {
    }

    @Override
    public DefaultMobileClientBuilder endpointProvider(MobileEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MobileClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMobileClientBuilder.validateClientOptions(clientConfiguration);
        MobileServiceClientConfiguration serviceClientConfiguration = MobileServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultMobileClient(serviceClientConfiguration, clientConfiguration);
    }
}

