/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.RecommendationSet;
import software.amazon.awssdk.services.migrationhubstrategy.model.StrategyRecommendation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerStrategy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerStrategy> {
    private static final SdkField<Boolean> IS_PREFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPreferred").getter(ServerStrategy.getter(ServerStrategy::isPreferred)).setter(ServerStrategy.setter(Builder::isPreferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPreferred").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_APPLICATION_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfApplicationComponents").getter(ServerStrategy.getter(ServerStrategy::numberOfApplicationComponents)).setter(ServerStrategy.setter(Builder::numberOfApplicationComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfApplicationComponents").build()}).build();
    private static final SdkField<RecommendationSet> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendation").getter(ServerStrategy.getter(ServerStrategy::recommendation)).setter(ServerStrategy.setter(Builder::recommendation)).constructor(RecommendationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServerStrategy.getter(ServerStrategy::statusAsString)).setter(ServerStrategy.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PREFERRED_FIELD, NUMBER_OF_APPLICATION_COMPONENTS_FIELD, RECOMMENDATION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerStrategy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isPreferred;
    private final Integer numberOfApplicationComponents;
    private final RecommendationSet recommendation;
    private final String status;

    private ServerStrategy(BuilderImpl builder) {
        this.isPreferred = builder.isPreferred;
        this.numberOfApplicationComponents = builder.numberOfApplicationComponents;
        this.recommendation = builder.recommendation;
        this.status = builder.status;
    }

    public final Boolean isPreferred() {
        return this.isPreferred;
    }

    public final Integer numberOfApplicationComponents() {
        return this.numberOfApplicationComponents;
    }

    public final RecommendationSet recommendation() {
        return this.recommendation;
    }

    public final StrategyRecommendation status() {
        return StrategyRecommendation.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isPreferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfApplicationComponents());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerStrategy)) {
            return false;
        }
        ServerStrategy other = (ServerStrategy)obj;
        return Objects.equals(this.isPreferred(), other.isPreferred()) && Objects.equals(this.numberOfApplicationComponents(), other.numberOfApplicationComponents()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServerStrategy").add("IsPreferred", (Object)this.isPreferred()).add("NumberOfApplicationComponents", (Object)this.numberOfApplicationComponents()).add("Recommendation", (Object)this.recommendation()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isPreferred": {
                return Optional.ofNullable(clazz.cast(this.isPreferred()));
            }
            case "numberOfApplicationComponents": {
                return Optional.ofNullable(clazz.cast(this.numberOfApplicationComponents()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPreferred", IS_PREFERRED_FIELD);
        map.put("numberOfApplicationComponents", NUMBER_OF_APPLICATION_COMPONENTS_FIELD);
        map.put("recommendation", RECOMMENDATION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerStrategy, T> g) {
        return obj -> g.apply((ServerStrategy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isPreferred;
        private Integer numberOfApplicationComponents;
        private RecommendationSet recommendation;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerStrategy model) {
            this.isPreferred(model.isPreferred);
            this.numberOfApplicationComponents(model.numberOfApplicationComponents);
            this.recommendation(model.recommendation);
            this.status(model.status);
        }

        public final Boolean getIsPreferred() {
            return this.isPreferred;
        }

        public final void setIsPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
        }

        @Override
        public final Builder isPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
            return this;
        }

        public final Integer getNumberOfApplicationComponents() {
            return this.numberOfApplicationComponents;
        }

        public final void setNumberOfApplicationComponents(Integer numberOfApplicationComponents) {
            this.numberOfApplicationComponents = numberOfApplicationComponents;
        }

        @Override
        public final Builder numberOfApplicationComponents(Integer numberOfApplicationComponents) {
            this.numberOfApplicationComponents = numberOfApplicationComponents;
            return this;
        }

        public final RecommendationSet.Builder getRecommendation() {
            return this.recommendation != null ? this.recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationSet.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationSet recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StrategyRecommendation status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ServerStrategy build() {
            return new ServerStrategy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerStrategy> {
        public Builder isPreferred(Boolean var1);

        public Builder numberOfApplicationComponents(Integer var1);

        public Builder recommendation(RecommendationSet var1);

        default public Builder recommendation(Consumer<RecommendationSet.Builder> recommendation) {
            return this.recommendation((RecommendationSet)((RecommendationSet.Builder)RecommendationSet.builder().applyMutation(recommendation)).build());
        }

        public Builder status(String var1);

        public Builder status(StrategyRecommendation var1);
    }
}

