/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplicationsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServerDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServerDetailsResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, GetServerDetailsResponse> {
    private static final SdkField<List<AssociatedApplication>> ASSOCIATED_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedApplications").getter(GetServerDetailsResponse.getter(GetServerDetailsResponse::associatedApplications)).setter(GetServerDetailsResponse.setter(Builder::associatedApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetServerDetailsResponse.getter(GetServerDetailsResponse::nextToken)).setter(GetServerDetailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<ServerDetail> SERVER_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverDetail").getter(GetServerDetailsResponse.getter(GetServerDetailsResponse::serverDetail)).setter(GetServerDetailsResponse.setter(Builder::serverDetail)).constructor(ServerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_APPLICATIONS_FIELD, NEXT_TOKEN_FIELD, SERVER_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetServerDetailsResponse.memberNameToFieldInitializer();
    private final List<AssociatedApplication> associatedApplications;
    private final String nextToken;
    private final ServerDetail serverDetail;

    private GetServerDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.associatedApplications = builder.associatedApplications;
        this.nextToken = builder.nextToken;
        this.serverDetail = builder.serverDetail;
    }

    public final boolean hasAssociatedApplications() {
        return this.associatedApplications != null && !(this.associatedApplications instanceof SdkAutoConstructList);
    }

    public final List<AssociatedApplication> associatedApplications() {
        return this.associatedApplications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ServerDetail serverDetail() {
        return this.serverDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedApplications() ? this.associatedApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServerDetailsResponse)) {
            return false;
        }
        GetServerDetailsResponse other = (GetServerDetailsResponse)((Object)obj);
        return this.hasAssociatedApplications() == other.hasAssociatedApplications() && Objects.equals(this.associatedApplications(), other.associatedApplications()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.serverDetail(), other.serverDetail());
    }

    public final String toString() {
        return ToString.builder((String)"GetServerDetailsResponse").add("AssociatedApplications", this.hasAssociatedApplications() ? this.associatedApplications() : null).add("NextToken", (Object)this.nextToken()).add("ServerDetail", (Object)this.serverDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedApplications": {
                return Optional.ofNullable(clazz.cast(this.associatedApplications()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "serverDetail": {
                return Optional.ofNullable(clazz.cast(this.serverDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associatedApplications", ASSOCIATED_APPLICATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serverDetail", SERVER_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServerDetailsResponse, T> g) {
        return obj -> g.apply((GetServerDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<AssociatedApplication> associatedApplications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private ServerDetail serverDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServerDetailsResponse model) {
            super(model);
            this.associatedApplications(model.associatedApplications);
            this.nextToken(model.nextToken);
            this.serverDetail(model.serverDetail);
        }

        public final List<AssociatedApplication.Builder> getAssociatedApplications() {
            List<AssociatedApplication.Builder> result = AssociatedApplicationsCopier.copyToBuilder(this.associatedApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedApplications(Collection<AssociatedApplication.BuilderImpl> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copyFromBuilder(associatedApplications);
        }

        @Override
        public final Builder associatedApplications(Collection<AssociatedApplication> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copy(associatedApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(AssociatedApplication ... associatedApplications) {
            this.associatedApplications(Arrays.asList(associatedApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(Consumer<AssociatedApplication.Builder> ... associatedApplications) {
            this.associatedApplications(Stream.of(associatedApplications).map(c -> (AssociatedApplication)((AssociatedApplication.Builder)AssociatedApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ServerDetail.Builder getServerDetail() {
            return this.serverDetail != null ? this.serverDetail.toBuilder() : null;
        }

        public final void setServerDetail(ServerDetail.BuilderImpl serverDetail) {
            this.serverDetail = serverDetail != null ? serverDetail.build() : null;
        }

        @Override
        public final Builder serverDetail(ServerDetail serverDetail) {
            this.serverDetail = serverDetail;
            return this;
        }

        @Override
        public GetServerDetailsResponse build() {
            return new GetServerDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServerDetailsResponse> {
        public Builder associatedApplications(Collection<AssociatedApplication> var1);

        public Builder associatedApplications(AssociatedApplication ... var1);

        public Builder associatedApplications(Consumer<AssociatedApplication.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder serverDetail(ServerDetail var1);

        default public Builder serverDetail(Consumer<ServerDetail.Builder> serverDetail) {
            return this.serverDetail((ServerDetail)((ServerDetail.Builder)ServerDetail.builder().applyMutation(serverDetail)).build());
        }
    }
}

