/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse;

public class GetServerDetailsIterable
implements SdkIterable<GetServerDetailsResponse> {
    private final MigrationHubStrategyClient client;
    private final GetServerDetailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetServerDetailsIterable(MigrationHubStrategyClient client, GetServerDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetServerDetailsResponseFetcher();
    }

    public Iterator<GetServerDetailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociatedApplication> associatedApplications() {
        Function<GetServerDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedApplications() != null) {
                return response.associatedApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetServerDetailsResponseFetcher
    implements SyncPageFetcher<GetServerDetailsResponse> {
        private GetServerDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetServerDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetServerDetailsResponse nextPage(GetServerDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetServerDetailsIterable.this.client.getServerDetails(GetServerDetailsIterable.this.firstRequest);
            }
            return GetServerDetailsIterable.this.client.getServerDetails((GetServerDetailsRequest)((Object)GetServerDetailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

