/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTarget;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssessmentTargetsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.DataCollectionDetails;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssessmentResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, GetAssessmentResponse> {
    private static final SdkField<List<AssessmentTarget>> ASSESSMENT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTargets").getter(GetAssessmentResponse.getter(GetAssessmentResponse::assessmentTargets)).setter(GetAssessmentResponse.setter(Builder::assessmentTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataCollectionDetails> DATA_COLLECTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataCollectionDetails").getter(GetAssessmentResponse.getter(GetAssessmentResponse::dataCollectionDetails)).setter(GetAssessmentResponse.setter(Builder::dataCollectionDetails)).constructor(DataCollectionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionDetails").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAssessmentResponse.getter(GetAssessmentResponse::id)).setter(GetAssessmentResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGETS_FIELD, DATA_COLLECTION_DETAILS_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssessmentResponse.memberNameToFieldInitializer();
    private final List<AssessmentTarget> assessmentTargets;
    private final DataCollectionDetails dataCollectionDetails;
    private final String id;

    private GetAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargets = builder.assessmentTargets;
        this.dataCollectionDetails = builder.dataCollectionDetails;
        this.id = builder.id;
    }

    public final boolean hasAssessmentTargets() {
        return this.assessmentTargets != null && !(this.assessmentTargets instanceof SdkAutoConstructList);
    }

    public final List<AssessmentTarget> assessmentTargets() {
        return this.assessmentTargets;
    }

    public final DataCollectionDetails dataCollectionDetails() {
        return this.dataCollectionDetails;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTargets() ? this.assessmentTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCollectionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentResponse)) {
            return false;
        }
        GetAssessmentResponse other = (GetAssessmentResponse)((Object)obj);
        return this.hasAssessmentTargets() == other.hasAssessmentTargets() && Objects.equals(this.assessmentTargets(), other.assessmentTargets()) && Objects.equals(this.dataCollectionDetails(), other.dataCollectionDetails()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssessmentResponse").add("AssessmentTargets", this.hasAssessmentTargets() ? this.assessmentTargets() : null).add("DataCollectionDetails", (Object)this.dataCollectionDetails()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargets": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargets()));
            }
            case "dataCollectionDetails": {
                return Optional.ofNullable(clazz.cast(this.dataCollectionDetails()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assessmentTargets", ASSESSMENT_TARGETS_FIELD);
        map.put("dataCollectionDetails", DATA_COLLECTION_DETAILS_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentResponse, T> g) {
        return obj -> g.apply((GetAssessmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<AssessmentTarget> assessmentTargets = DefaultSdkAutoConstructList.getInstance();
        private DataCollectionDetails dataCollectionDetails;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentResponse model) {
            super(model);
            this.assessmentTargets(model.assessmentTargets);
            this.dataCollectionDetails(model.dataCollectionDetails);
            this.id(model.id);
        }

        public final List<AssessmentTarget.Builder> getAssessmentTargets() {
            List<AssessmentTarget.Builder> result = AssessmentTargetsCopier.copyToBuilder(this.assessmentTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentTargets(Collection<AssessmentTarget.BuilderImpl> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetsCopier.copyFromBuilder(assessmentTargets);
        }

        @Override
        public final Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetsCopier.copy(assessmentTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(AssessmentTarget ... assessmentTargets) {
            this.assessmentTargets(Arrays.asList(assessmentTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(Consumer<AssessmentTarget.Builder> ... assessmentTargets) {
            this.assessmentTargets(Stream.of(assessmentTargets).map(c -> (AssessmentTarget)((AssessmentTarget.Builder)AssessmentTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataCollectionDetails.Builder getDataCollectionDetails() {
            return this.dataCollectionDetails != null ? this.dataCollectionDetails.toBuilder() : null;
        }

        public final void setDataCollectionDetails(DataCollectionDetails.BuilderImpl dataCollectionDetails) {
            this.dataCollectionDetails = dataCollectionDetails != null ? dataCollectionDetails.build() : null;
        }

        @Override
        public final Builder dataCollectionDetails(DataCollectionDetails dataCollectionDetails) {
            this.dataCollectionDetails = dataCollectionDetails;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public GetAssessmentResponse build() {
            return new GetAssessmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssessmentResponse> {
        public Builder assessmentTargets(Collection<AssessmentTarget> var1);

        public Builder assessmentTargets(AssessmentTarget ... var1);

        public Builder assessmentTargets(Consumer<AssessmentTarget.Builder> ... var1);

        public Builder dataCollectionDetails(DataCollectionDetails var1);

        default public Builder dataCollectionDetails(Consumer<DataCollectionDetails.Builder> dataCollectionDetails) {
            return this.dataCollectionDetails((DataCollectionDetails)((DataCollectionDetails.Builder)DataCollectionDetails.builder().applyMutation(dataCollectionDetails)).build());
        }

        public Builder id(String var1);
    }
}

