/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentStrategiesCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentStrategy;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationComponentStrategiesResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, GetApplicationComponentStrategiesResponse> {
    private static final SdkField<List<ApplicationComponentStrategy>> APPLICATION_COMPONENT_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationComponentStrategies").getter(GetApplicationComponentStrategiesResponse.getter(GetApplicationComponentStrategiesResponse::applicationComponentStrategies)).setter(GetApplicationComponentStrategiesResponse.setter(Builder::applicationComponentStrategies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentStrategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationComponentStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_STRATEGIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationComponentStrategies", APPLICATION_COMPONENT_STRATEGIES_FIELD);
        }
    });
    private final List<ApplicationComponentStrategy> applicationComponentStrategies;

    private GetApplicationComponentStrategiesResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentStrategies = builder.applicationComponentStrategies;
    }

    public final boolean hasApplicationComponentStrategies() {
        return this.applicationComponentStrategies != null && !(this.applicationComponentStrategies instanceof SdkAutoConstructList);
    }

    public final List<ApplicationComponentStrategy> applicationComponentStrategies() {
        return this.applicationComponentStrategies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationComponentStrategies() ? this.applicationComponentStrategies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationComponentStrategiesResponse)) {
            return false;
        }
        GetApplicationComponentStrategiesResponse other = (GetApplicationComponentStrategiesResponse)((Object)obj);
        return this.hasApplicationComponentStrategies() == other.hasApplicationComponentStrategies() && Objects.equals(this.applicationComponentStrategies(), other.applicationComponentStrategies());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationComponentStrategiesResponse").add("ApplicationComponentStrategies", this.hasApplicationComponentStrategies() ? this.applicationComponentStrategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationComponentStrategies": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentStrategies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationComponentStrategiesResponse, T> g) {
        return obj -> g.apply((GetApplicationComponentStrategiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<ApplicationComponentStrategy> applicationComponentStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationComponentStrategiesResponse model) {
            super(model);
            this.applicationComponentStrategies(model.applicationComponentStrategies);
        }

        public final List<ApplicationComponentStrategy.Builder> getApplicationComponentStrategies() {
            List<ApplicationComponentStrategy.Builder> result = ApplicationComponentStrategiesCopier.copyToBuilder(this.applicationComponentStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentStrategies(Collection<ApplicationComponentStrategy.BuilderImpl> applicationComponentStrategies) {
            this.applicationComponentStrategies = ApplicationComponentStrategiesCopier.copyFromBuilder(applicationComponentStrategies);
        }

        @Override
        public final Builder applicationComponentStrategies(Collection<ApplicationComponentStrategy> applicationComponentStrategies) {
            this.applicationComponentStrategies = ApplicationComponentStrategiesCopier.copy(applicationComponentStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentStrategies(ApplicationComponentStrategy ... applicationComponentStrategies) {
            this.applicationComponentStrategies(Arrays.asList(applicationComponentStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentStrategies(Consumer<ApplicationComponentStrategy.Builder> ... applicationComponentStrategies) {
            this.applicationComponentStrategies(Stream.of(applicationComponentStrategies).map(c -> (ApplicationComponentStrategy)((ApplicationComponentStrategy.Builder)ApplicationComponentStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetApplicationComponentStrategiesResponse build() {
            return new GetApplicationComponentStrategiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationComponentStrategiesResponse> {
        public Builder applicationComponentStrategies(Collection<ApplicationComponentStrategy> var1);

        public Builder applicationComponentStrategies(ApplicationComponentStrategy ... var1);

        public Builder applicationComponentStrategies(Consumer<ApplicationComponentStrategy.Builder> ... var1);
    }
}

