/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.DataSourceType;
import software.amazon.awssdk.services.migrationhubstrategy.model.Group;
import software.amazon.awssdk.services.migrationhubstrategy.model.GroupIdsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportFileTaskRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, StartImportFileTaskRequest> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(StartImportFileTaskRequest.getter(StartImportFileTaskRequest::s3Bucket)).setter(StartImportFileTaskRequest.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceType").getter(StartImportFileTaskRequest.getter(StartImportFileTaskRequest::dataSourceTypeAsString)).setter(StartImportFileTaskRequest.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()}).build();
    private static final SdkField<List<Group>> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupId").getter(StartImportFileTaskRequest.getter(StartImportFileTaskRequest::groupId)).setter(StartImportFileTaskRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartImportFileTaskRequest.getter(StartImportFileTaskRequest::name)).setter(StartImportFileTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> S3_BUCKET_FOR_REPORT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3bucketForReportData").getter(StartImportFileTaskRequest.getter(StartImportFileTaskRequest::s3bucketForReportData)).setter(StartImportFileTaskRequest.setter(Builder::s3bucketForReportData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForReportData").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3key").getter(StartImportFileTaskRequest.getter(StartImportFileTaskRequest::s3key)).setter(StartImportFileTaskRequest.setter(Builder::s3key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, DATA_SOURCE_TYPE_FIELD, GROUP_ID_FIELD, NAME_FIELD, S3_BUCKET_FOR_REPORT_DATA_FIELD, S3_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S3Bucket", S3_BUCKET_FIELD);
            this.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
            this.put("groupId", GROUP_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("s3bucketForReportData", S3_BUCKET_FOR_REPORT_DATA_FIELD);
            this.put("s3key", S3_KEY_FIELD);
        }
    });
    private final String s3Bucket;
    private final String dataSourceType;
    private final List<Group> groupId;
    private final String name;
    private final String s3bucketForReportData;
    private final String s3key;

    private StartImportFileTaskRequest(BuilderImpl builder) {
        super(builder);
        this.s3Bucket = builder.s3Bucket;
        this.dataSourceType = builder.dataSourceType;
        this.groupId = builder.groupId;
        this.name = builder.name;
        this.s3bucketForReportData = builder.s3bucketForReportData;
        this.s3key = builder.s3key;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final DataSourceType dataSourceType() {
        return DataSourceType.fromValue(this.dataSourceType);
    }

    public final String dataSourceTypeAsString() {
        return this.dataSourceType;
    }

    public final boolean hasGroupId() {
        return this.groupId != null && !(this.groupId instanceof SdkAutoConstructList);
    }

    public final List<Group> groupId() {
        return this.groupId;
    }

    public final String name() {
        return this.name;
    }

    public final String s3bucketForReportData() {
        return this.s3bucketForReportData;
    }

    public final String s3key() {
        return this.s3key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupId() ? this.groupId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3bucketForReportData());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportFileTaskRequest)) {
            return false;
        }
        StartImportFileTaskRequest other = (StartImportFileTaskRequest)((Object)obj);
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.dataSourceTypeAsString(), other.dataSourceTypeAsString()) && this.hasGroupId() == other.hasGroupId() && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.s3bucketForReportData(), other.s3bucketForReportData()) && Objects.equals(this.s3key(), other.s3key());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportFileTaskRequest").add("S3Bucket", (Object)this.s3Bucket()).add("DataSourceType", (Object)this.dataSourceTypeAsString()).add("GroupId", this.hasGroupId() ? this.groupId() : null).add("Name", (Object)this.name()).add("S3bucketForReportData", (Object)this.s3bucketForReportData()).add("S3key", (Object)this.s3key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "dataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceTypeAsString()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "s3bucketForReportData": {
                return Optional.ofNullable(clazz.cast(this.s3bucketForReportData()));
            }
            case "s3key": {
                return Optional.ofNullable(clazz.cast(this.s3key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartImportFileTaskRequest, T> g) {
        return obj -> g.apply((StartImportFileTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String dataSourceType;
        private List<Group> groupId = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String s3bucketForReportData;
        private String s3key;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportFileTaskRequest model) {
            super(model);
            this.s3Bucket(model.s3Bucket);
            this.dataSourceType(model.dataSourceType);
            this.groupId(model.groupId);
            this.name(model.name);
            this.s3bucketForReportData(model.s3bucketForReportData);
            this.s3key(model.s3key);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(DataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final List<Group.Builder> getGroupId() {
            List<Group.Builder> result = GroupIdsCopier.copyToBuilder(this.groupId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupId(Collection<Group.BuilderImpl> groupId) {
            this.groupId = GroupIdsCopier.copyFromBuilder(groupId);
        }

        @Override
        public final Builder groupId(Collection<Group> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(Group ... groupId) {
            this.groupId(Arrays.asList(groupId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(Consumer<Group.Builder> ... groupId) {
            this.groupId(Stream.of(groupId).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getS3bucketForReportData() {
            return this.s3bucketForReportData;
        }

        public final void setS3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
        }

        @Override
        public final Builder s3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
            return this;
        }

        public final String getS3key() {
            return this.s3key;
        }

        public final void setS3key(String s3key) {
            this.s3key = s3key;
        }

        @Override
        public final Builder s3key(String s3key) {
            this.s3key = s3key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportFileTaskRequest build() {
            return new StartImportFileTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportFileTaskRequest> {
        public Builder s3Bucket(String var1);

        public Builder dataSourceType(String var1);

        public Builder dataSourceType(DataSourceType var1);

        public Builder groupId(Collection<Group> var1);

        public Builder groupId(Group ... var1);

        public Builder groupId(Consumer<Group.Builder> ... var1);

        public Builder name(String var1);

        public Builder s3bucketForReportData(String var1);

        public Builder s3key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

