/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyAsyncClient;
import software.amazon.awssdk.services.migrationhubstrategy.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhubstrategy.model.Collector;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse;

public class ListCollectorsPublisher
implements SdkPublisher<ListCollectorsResponse> {
    private final MigrationHubStrategyAsyncClient client;
    private final ListCollectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollectorsPublisher(MigrationHubStrategyAsyncClient client, ListCollectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollectorsPublisher(MigrationHubStrategyAsyncClient client, ListCollectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Collector> collectors() {
        Function<ListCollectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collectors() != null) {
                return response.collectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollectorsResponseFetcher
    implements AsyncPageFetcher<ListCollectorsResponse> {
        private ListCollectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollectorsResponse> nextPage(ListCollectorsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectorsPublisher.this.client.listCollectors(ListCollectorsPublisher.this.firstRequest);
            }
            return ListCollectorsPublisher.this.client.listCollectors((ListCollectorsRequest)((Object)ListCollectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

