/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.migrationhubstrategy.model.RuntimeAnalysisStatus;
import software.amazon.awssdk.services.migrationhubstrategy.model.SrcCodeOrDbAnalysisStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisStatusUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisStatusUnion> {
    private static final SdkField<String> RUNTIME_ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeAnalysisStatus").getter(AnalysisStatusUnion.getter(AnalysisStatusUnion::runtimeAnalysisStatusAsString)).setter(AnalysisStatusUnion.setter(Builder::runtimeAnalysisStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeAnalysisStatus").build()}).build();
    private static final SdkField<String> SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("srcCodeOrDbAnalysisStatus").getter(AnalysisStatusUnion.getter(AnalysisStatusUnion::srcCodeOrDbAnalysisStatusAsString)).setter(AnalysisStatusUnion.setter(Builder::srcCodeOrDbAnalysisStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srcCodeOrDbAnalysisStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_ANALYSIS_STATUS_FIELD, SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String runtimeAnalysisStatus;
    private final String srcCodeOrDbAnalysisStatus;
    private final Type type;

    private AnalysisStatusUnion(BuilderImpl builder) {
        this.runtimeAnalysisStatus = builder.runtimeAnalysisStatus;
        this.srcCodeOrDbAnalysisStatus = builder.srcCodeOrDbAnalysisStatus;
        this.type = builder.type;
    }

    public final RuntimeAnalysisStatus runtimeAnalysisStatus() {
        return RuntimeAnalysisStatus.fromValue(this.runtimeAnalysisStatus);
    }

    public final String runtimeAnalysisStatusAsString() {
        return this.runtimeAnalysisStatus;
    }

    public final SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus() {
        return SrcCodeOrDbAnalysisStatus.fromValue(this.srcCodeOrDbAnalysisStatus);
    }

    public final String srcCodeOrDbAnalysisStatusAsString() {
        return this.srcCodeOrDbAnalysisStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAnalysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.srcCodeOrDbAnalysisStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisStatusUnion)) {
            return false;
        }
        AnalysisStatusUnion other = (AnalysisStatusUnion)obj;
        return Objects.equals(this.runtimeAnalysisStatusAsString(), other.runtimeAnalysisStatusAsString()) && Objects.equals(this.srcCodeOrDbAnalysisStatusAsString(), other.srcCodeOrDbAnalysisStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisStatusUnion").add("RuntimeAnalysisStatus", (Object)this.runtimeAnalysisStatusAsString()).add("SrcCodeOrDbAnalysisStatus", (Object)this.srcCodeOrDbAnalysisStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runtimeAnalysisStatus": {
                return Optional.ofNullable(clazz.cast(this.runtimeAnalysisStatusAsString()));
            }
            case "srcCodeOrDbAnalysisStatus": {
                return Optional.ofNullable(clazz.cast(this.srcCodeOrDbAnalysisStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public static AnalysisStatusUnion fromRuntimeAnalysisStatus(String runtimeAnalysisStatus) {
        return (AnalysisStatusUnion)AnalysisStatusUnion.builder().runtimeAnalysisStatus(runtimeAnalysisStatus).build();
    }

    public static AnalysisStatusUnion fromRuntimeAnalysisStatus(RuntimeAnalysisStatus runtimeAnalysisStatus) {
        return (AnalysisStatusUnion)AnalysisStatusUnion.builder().runtimeAnalysisStatus(runtimeAnalysisStatus).build();
    }

    public static AnalysisStatusUnion fromSrcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
        return (AnalysisStatusUnion)AnalysisStatusUnion.builder().srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus).build();
    }

    public static AnalysisStatusUnion fromSrcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus) {
        return (AnalysisStatusUnion)AnalysisStatusUnion.builder().srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisStatusUnion, T> g) {
        return obj -> g.apply((AnalysisStatusUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RUNTIME_ANALYSIS_STATUS,
        SRC_CODE_OR_DB_ANALYSIS_STATUS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String runtimeAnalysisStatus;
        private String srcCodeOrDbAnalysisStatus;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisStatusUnion model) {
            this.runtimeAnalysisStatus(model.runtimeAnalysisStatus);
            this.srcCodeOrDbAnalysisStatus(model.srcCodeOrDbAnalysisStatus);
        }

        public final String getRuntimeAnalysisStatus() {
            return this.runtimeAnalysisStatus;
        }

        public final void setRuntimeAnalysisStatus(String runtimeAnalysisStatus) {
            String oldValue = this.runtimeAnalysisStatus;
            this.runtimeAnalysisStatus = runtimeAnalysisStatus;
            this.handleUnionValueChange(Type.RUNTIME_ANALYSIS_STATUS, oldValue, this.runtimeAnalysisStatus);
        }

        @Override
        public final Builder runtimeAnalysisStatus(String runtimeAnalysisStatus) {
            String oldValue = this.runtimeAnalysisStatus;
            this.runtimeAnalysisStatus = runtimeAnalysisStatus;
            this.handleUnionValueChange(Type.RUNTIME_ANALYSIS_STATUS, oldValue, this.runtimeAnalysisStatus);
            return this;
        }

        @Override
        public final Builder runtimeAnalysisStatus(RuntimeAnalysisStatus runtimeAnalysisStatus) {
            this.runtimeAnalysisStatus(runtimeAnalysisStatus == null ? null : runtimeAnalysisStatus.toString());
            return this;
        }

        public final String getSrcCodeOrDbAnalysisStatus() {
            return this.srcCodeOrDbAnalysisStatus;
        }

        public final void setSrcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
            String oldValue = this.srcCodeOrDbAnalysisStatus;
            this.srcCodeOrDbAnalysisStatus = srcCodeOrDbAnalysisStatus;
            this.handleUnionValueChange(Type.SRC_CODE_OR_DB_ANALYSIS_STATUS, oldValue, this.srcCodeOrDbAnalysisStatus);
        }

        @Override
        public final Builder srcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
            String oldValue = this.srcCodeOrDbAnalysisStatus;
            this.srcCodeOrDbAnalysisStatus = srcCodeOrDbAnalysisStatus;
            this.handleUnionValueChange(Type.SRC_CODE_OR_DB_ANALYSIS_STATUS, oldValue, this.srcCodeOrDbAnalysisStatus);
            return this;
        }

        @Override
        public final Builder srcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus) {
            this.srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus == null ? null : srcCodeOrDbAnalysisStatus.toString());
            return this;
        }

        public AnalysisStatusUnion build() {
            return new AnalysisStatusUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisStatusUnion> {
        public Builder runtimeAnalysisStatus(String var1);

        public Builder runtimeAnalysisStatus(RuntimeAnalysisStatus var1);

        public Builder srcCodeOrDbAnalysisStatus(String var1);

        public Builder srcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus var1);
    }
}

