/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Severity {
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    LOW("LOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Severity> VALUE_MAP;
    private final String value;

    private Severity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Severity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Severity> knownValues() {
        EnumSet<Severity> knownValues = EnumSet.allOf(Severity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Severity.class, Severity::toString);
    }
}

