/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.Strategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StrategySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StrategySummary> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(StrategySummary.getter(StrategySummary::count)).setter(StrategySummary.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("strategy").getter(StrategySummary.getter(StrategySummary::strategyAsString)).setter(StrategySummary.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer count;
    private final String strategy;

    private StrategySummary(BuilderImpl builder) {
        this.count = builder.count;
        this.strategy = builder.strategy;
    }

    public final Integer count() {
        return this.count;
    }

    public final Strategy strategy() {
        return Strategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrategySummary)) {
            return false;
        }
        StrategySummary other = (StrategySummary)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.strategyAsString(), other.strategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StrategySummary").add("Count", (Object)this.count()).add("Strategy", (Object)this.strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StrategySummary, T> g) {
        return obj -> g.apply((StrategySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StrategySummary model) {
            this.count(model.count);
            this.strategy(model.strategy);
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(Strategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public StrategySummary build() {
            return new StrategySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StrategySummary> {
        public Builder count(Integer var1);

        public Builder strategy(String var1);

        public Builder strategy(Strategy var1);
    }
}

