/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StrategyOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServerConfigRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, UpdateServerConfigRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverId").getter(UpdateServerConfigRequest.getter(UpdateServerConfigRequest::serverId)).setter(UpdateServerConfigRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverId").build()}).build();
    private static final SdkField<StrategyOption> STRATEGY_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("strategyOption").getter(UpdateServerConfigRequest.getter(UpdateServerConfigRequest::strategyOption)).setter(UpdateServerConfigRequest.setter(Builder::strategyOption)).constructor(StrategyOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategyOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, STRATEGY_OPTION_FIELD));
    private final String serverId;
    private final StrategyOption strategyOption;

    private UpdateServerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.strategyOption = builder.strategyOption;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final StrategyOption strategyOption() {
        return this.strategyOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyOption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerConfigRequest)) {
            return false;
        }
        UpdateServerConfigRequest other = (UpdateServerConfigRequest)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.strategyOption(), other.strategyOption());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServerConfigRequest").add("ServerId", (Object)this.serverId()).add("StrategyOption", (Object)this.strategyOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "strategyOption": {
                return Optional.ofNullable(clazz.cast(this.strategyOption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerConfigRequest, T> g) {
        return obj -> g.apply((UpdateServerConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private String serverId;
        private StrategyOption strategyOption;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerConfigRequest model) {
            super(model);
            this.serverId(model.serverId);
            this.strategyOption(model.strategyOption);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final StrategyOption.Builder getStrategyOption() {
            return this.strategyOption != null ? this.strategyOption.toBuilder() : null;
        }

        public final void setStrategyOption(StrategyOption.BuilderImpl strategyOption) {
            this.strategyOption = strategyOption != null ? strategyOption.build() : null;
        }

        @Override
        public final Builder strategyOption(StrategyOption strategyOption) {
            this.strategyOption = strategyOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerConfigRequest build() {
            return new UpdateServerConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServerConfigRequest> {
        public Builder serverId(String var1);

        public Builder strategyOption(StrategyOption var1);

        default public Builder strategyOption(Consumer<StrategyOption.Builder> strategyOption) {
            return this.strategyOption((StrategyOption)((StrategyOption.Builder)StrategyOption.builder().applyMutation(strategyOption)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

