/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.Collector;
import software.amazon.awssdk.services.migrationhubstrategy.model.CollectorsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollectorsResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, ListCollectorsResponse> {
    private static final SdkField<List<Collector>> COLLECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Collectors").getter(ListCollectorsResponse.getter(ListCollectorsResponse::collectors)).setter(ListCollectorsResponse.setter(Builder::collectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Collector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollectorsResponse.getter(ListCollectorsResponse::nextToken)).setter(ListCollectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Collector> collectors;
    private final String nextToken;

    private ListCollectorsResponse(BuilderImpl builder) {
        super(builder);
        this.collectors = builder.collectors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCollectors() {
        return this.collectors != null && !(this.collectors instanceof SdkAutoConstructList);
    }

    public final List<Collector> collectors() {
        return this.collectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectors() ? this.collectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectorsResponse)) {
            return false;
        }
        ListCollectorsResponse other = (ListCollectorsResponse)((Object)obj);
        return this.hasCollectors() == other.hasCollectors() && Objects.equals(this.collectors(), other.collectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollectorsResponse").add("Collectors", this.hasCollectors() ? this.collectors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Collectors": {
                return Optional.ofNullable(clazz.cast(this.collectors()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollectorsResponse, T> g) {
        return obj -> g.apply((ListCollectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private List<Collector> collectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectorsResponse model) {
            super(model);
            this.collectors(model.collectors);
            this.nextToken(model.nextToken);
        }

        public final List<Collector.Builder> getCollectors() {
            List<Collector.Builder> result = CollectorsCopier.copyToBuilder(this.collectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectors(Collection<Collector.BuilderImpl> collectors) {
            this.collectors = CollectorsCopier.copyFromBuilder(collectors);
        }

        @Override
        public final Builder collectors(Collection<Collector> collectors) {
            this.collectors = CollectorsCopier.copy(collectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Collector ... collectors) {
            this.collectors(Arrays.asList(collectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Consumer<Collector.Builder> ... collectors) {
            this.collectors(Stream.of(collectors).map(c -> (Collector)((Collector.Builder)Collector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollectorsResponse build() {
            return new ListCollectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollectorsResponse> {
        public Builder collectors(Collection<Collector> var1);

        public Builder collectors(Collector ... var1);

        public Builder collectors(Consumer<Collector.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

