/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppType {
    DOT_NET_FRAMEWORK("DotNetFramework"),
    JAVA("Java"),
    SQL_SERVER("SQLServer"),
    IIS("IIS"),
    ORACLE("Oracle"),
    OTHER("Other"),
    TOMCAT("Tomcat"),
    J_BOSS("JBoss"),
    SPRING("Spring"),
    MONGO_DB("Mongo DB"),
    DB2("DB2"),
    MARIA_DB("Maria DB"),
    MY_SQL("MySQL"),
    SYBASE("Sybase"),
    POSTGRE_SQL_SERVER("PostgreSQLServer"),
    CASSANDRA("Cassandra"),
    IBM_WEB_SPHERE("IBM WebSphere"),
    ORACLE_WEB_LOGIC("Oracle WebLogic"),
    VISUAL_BASIC("Visual Basic"),
    UNKNOWN("Unknown"),
    DOTNET_CORE("DotnetCore"),
    DOTNET("Dotnet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppType> VALUE_MAP;
    private final String value;

    private AppType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppType> knownValues() {
        EnumSet<AppType> knownValues = EnumSet.allOf(AppType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppType.class, AppType::toString);
    }
}

