/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse;

public class ListApplicationComponentsIterable
implements SdkIterable<ListApplicationComponentsResponse> {
    private final MigrationHubStrategyClient client;
    private final ListApplicationComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationComponentsIterable(MigrationHubStrategyClient client, ListApplicationComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationComponentsResponseFetcher();
    }

    public Iterator<ListApplicationComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationComponentDetail> applicationComponentInfos() {
        Function<ListApplicationComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationComponentInfos() != null) {
                return response.applicationComponentInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationComponentsResponseFetcher
    implements SyncPageFetcher<ListApplicationComponentsResponse> {
        private ListApplicationComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationComponentsResponse nextPage(ListApplicationComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationComponentsIterable.this.client.listApplicationComponents(ListApplicationComponentsIterable.this.firstRequest);
            }
            return ListApplicationComponentsIterable.this.client.listApplicationComponents((ListApplicationComponentsRequest)((Object)ListApplicationComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

