/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInfo> {
    private static final SdkField<String> INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceName").getter(NetworkInfo.getter(NetworkInfo::interfaceName)).setter(NetworkInfo.setter(Builder::interfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(NetworkInfo.getter(NetworkInfo::ipAddress)).setter(NetworkInfo.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("macAddress").getter(NetworkInfo.getter(NetworkInfo::macAddress)).setter(NetworkInfo.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()}).build();
    private static final SdkField<String> NET_MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("netMask").getter(NetworkInfo.getter(NetworkInfo::netMask)).setter(NetworkInfo.setter(Builder::netMask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("netMask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_NAME_FIELD, IP_ADDRESS_FIELD, MAC_ADDRESS_FIELD, NET_MASK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String interfaceName;
    private final String ipAddress;
    private final String macAddress;
    private final String netMask;

    private NetworkInfo(BuilderImpl builder) {
        this.interfaceName = builder.interfaceName;
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
        this.netMask = builder.netMask;
    }

    public final String interfaceName() {
        return this.interfaceName;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String netMask() {
        return this.netMask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.netMask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInfo)) {
            return false;
        }
        NetworkInfo other = (NetworkInfo)obj;
        return Objects.equals(this.interfaceName(), other.interfaceName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.netMask(), other.netMask());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInfo").add("InterfaceName", (Object)this.interfaceName()).add("IpAddress", (Object)this.ipAddress()).add("MacAddress", (Object)this.macAddress()).add("NetMask", (Object)this.netMask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interfaceName": {
                return Optional.ofNullable(clazz.cast(this.interfaceName()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "macAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "netMask": {
                return Optional.ofNullable(clazz.cast(this.netMask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInfo, T> g) {
        return obj -> g.apply((NetworkInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interfaceName;
        private String ipAddress;
        private String macAddress;
        private String netMask;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInfo model) {
            this.interfaceName(model.interfaceName);
            this.ipAddress(model.ipAddress);
            this.macAddress(model.macAddress);
            this.netMask(model.netMask);
        }

        public final String getInterfaceName() {
            return this.interfaceName;
        }

        public final void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        @Override
        public final Builder interfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getNetMask() {
            return this.netMask;
        }

        public final void setNetMask(String netMask) {
            this.netMask = netMask;
        }

        @Override
        public final Builder netMask(String netMask) {
            this.netMask = netMask;
            return this;
        }

        public NetworkInfo build() {
            return new NetworkInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInfo> {
        public Builder interfaceName(String var1);

        public Builder ipAddress(String var1);

        public Builder macAddress(String var1);

        public Builder netMask(String var1);
    }
}

