/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SrcCodeOrDbAnalysisStatus {
    ANALYSIS_TO_BE_SCHEDULED("ANALYSIS_TO_BE_SCHEDULED"),
    ANALYSIS_STARTED("ANALYSIS_STARTED"),
    ANALYSIS_SUCCESS("ANALYSIS_SUCCESS"),
    ANALYSIS_FAILED("ANALYSIS_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SrcCodeOrDbAnalysisStatus> VALUE_MAP;
    private final String value;

    private SrcCodeOrDbAnalysisStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SrcCodeOrDbAnalysisStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SrcCodeOrDbAnalysisStatus> knownValues() {
        EnumSet<SrcCodeOrDbAnalysisStatus> knownValues = EnumSet.allOf(SrcCodeOrDbAnalysisStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SrcCodeOrDbAnalysisStatus.class, SrcCodeOrDbAnalysisStatus::toString);
    }
}

