/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubrefactorspaces.MigrationHubRefactorSpacesClient;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse;

public class ListEnvironmentVpcsIterable
implements SdkIterable<ListEnvironmentVpcsResponse> {
    private final MigrationHubRefactorSpacesClient client;
    private final ListEnvironmentVpcsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentVpcsIterable(MigrationHubRefactorSpacesClient client, ListEnvironmentVpcsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnvironmentVpcsResponseFetcher();
    }

    public Iterator<ListEnvironmentVpcsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentVpc> environmentVpcList() {
        Function<ListEnvironmentVpcsResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentVpcList() != null) {
                return response.environmentVpcList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentVpcsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentVpcsResponse> {
        private ListEnvironmentVpcsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentVpcsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentVpcsResponse nextPage(ListEnvironmentVpcsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentVpcsIterable.this.client.listEnvironmentVpcs(ListEnvironmentVpcsIterable.this.firstRequest);
            }
            return ListEnvironmentVpcsIterable.this.client.listEnvironmentVpcs((ListEnvironmentVpcsRequest)((Object)ListEnvironmentVpcsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

