/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHomeRegionControlsResponse extends MigrationHubConfigResponse implements
        ToCopyableBuilder<DescribeHomeRegionControlsResponse.Builder, DescribeHomeRegionControlsResponse> {
    private static final SdkField<List<HomeRegionControl>> HOME_REGION_CONTROLS_FIELD = SdkField
            .<List<HomeRegionControl>> builder(MarshallingType.LIST)
            .memberName("HomeRegionControls")
            .getter(getter(DescribeHomeRegionControlsResponse::homeRegionControls))
            .setter(setter(Builder::homeRegionControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegionControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HomeRegionControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(HomeRegionControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeHomeRegionControlsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_REGION_CONTROLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HomeRegionControl> homeRegionControls;

    private final String nextToken;

    private DescribeHomeRegionControlsResponse(BuilderImpl builder) {
        super(builder);
        this.homeRegionControls = builder.homeRegionControls;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the HomeRegionControls property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasHomeRegionControls() {
        return homeRegionControls != null && !(homeRegionControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains your <code>HomeRegionControl</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHomeRegionControls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains your <code>HomeRegionControl</code> objects.
     */
    public final List<HomeRegionControl> homeRegionControls() {
        return homeRegionControls;
    }

    /**
     * <p>
     * If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve the next
     * page of results, make the call again using the returned token in <code>NextToken</code>.
     * </p>
     * 
     * @return If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve the
     *         next page of results, make the call again using the returned token in <code>NextToken</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHomeRegionControls() ? homeRegionControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHomeRegionControlsResponse)) {
            return false;
        }
        DescribeHomeRegionControlsResponse other = (DescribeHomeRegionControlsResponse) obj;
        return hasHomeRegionControls() == other.hasHomeRegionControls()
                && Objects.equals(homeRegionControls(), other.homeRegionControls())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHomeRegionControlsResponse")
                .add("HomeRegionControls", hasHomeRegionControls() ? homeRegionControls() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeRegionControls":
            return Optional.ofNullable(clazz.cast(homeRegionControls()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHomeRegionControlsResponse, T> g) {
        return obj -> g.apply((DescribeHomeRegionControlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHomeRegionControlsResponse> {
        /**
         * <p>
         * An array that contains your <code>HomeRegionControl</code> objects.
         * </p>
         * 
         * @param homeRegionControls
         *        An array that contains your <code>HomeRegionControl</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegionControls(Collection<HomeRegionControl> homeRegionControls);

        /**
         * <p>
         * An array that contains your <code>HomeRegionControl</code> objects.
         * </p>
         * 
         * @param homeRegionControls
         *        An array that contains your <code>HomeRegionControl</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegionControls(HomeRegionControl... homeRegionControls);

        /**
         * <p>
         * An array that contains your <code>HomeRegionControl</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HomeRegionControl>.Builder} avoiding the
         * need to create one manually via {@link List<HomeRegionControl>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HomeRegionControl>.Builder#build()} is called immediately
         * and its result is passed to {@link #homeRegionControls(List<HomeRegionControl>)}.
         * 
         * @param homeRegionControls
         *        a consumer that will call methods on {@link List<HomeRegionControl>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #homeRegionControls(List<HomeRegionControl>)
         */
        Builder homeRegionControls(Consumer<HomeRegionControl.Builder>... homeRegionControls);

        /**
         * <p>
         * If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve the next
         * page of results, make the call again using the returned token in <code>NextToken</code>.
         * </p>
         * 
         * @param nextToken
         *        If a <code>NextToken</code> was returned by a previous call, more results are available. To retrieve
         *        the next page of results, make the call again using the returned token in <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubConfigResponse.BuilderImpl implements Builder {
        private List<HomeRegionControl> homeRegionControls = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHomeRegionControlsResponse model) {
            super(model);
            homeRegionControls(model.homeRegionControls);
            nextToken(model.nextToken);
        }

        public final Collection<HomeRegionControl.Builder> getHomeRegionControls() {
            if (homeRegionControls instanceof SdkAutoConstructList) {
                return null;
            }
            return homeRegionControls != null ? homeRegionControls.stream().map(HomeRegionControl::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder homeRegionControls(Collection<HomeRegionControl> homeRegionControls) {
            this.homeRegionControls = HomeRegionControlsCopier.copy(homeRegionControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeRegionControls(HomeRegionControl... homeRegionControls) {
            homeRegionControls(Arrays.asList(homeRegionControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeRegionControls(Consumer<HomeRegionControl.Builder>... homeRegionControls) {
            homeRegionControls(Stream.of(homeRegionControls).map(c -> HomeRegionControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHomeRegionControls(Collection<HomeRegionControl.BuilderImpl> homeRegionControls) {
            this.homeRegionControls = HomeRegionControlsCopier.copyFromBuilder(homeRegionControls);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHomeRegionControlsResponse build() {
            return new DescribeHomeRegionControlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
