/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * MigrationTaskSummary includes <code>MigrationTaskName</code>, <code>ProgressPercent</code>,
 * <code>ProgressUpdateStream</code>, <code>Status</code>, and <code>UpdateDateTime</code> for each task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MigrationTaskSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MigrationTaskSummary.Builder, MigrationTaskSummary> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgressUpdateStream").getter(getter(MigrationTaskSummary::progressUpdateStream))
            .setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationTaskName").getter(getter(MigrationTaskSummary::migrationTaskName))
            .setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MigrationTaskSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PROGRESS_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgressPercent").getter(getter(MigrationTaskSummary::progressPercent))
            .setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()).build();

    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetail").getter(getter(MigrationTaskSummary::statusDetail)).setter(setter(Builder::statusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateDateTime").getter(getter(MigrationTaskSummary::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, STATUS_FIELD, PROGRESS_PERCENT_FIELD, STATUS_DETAIL_FIELD, UPDATE_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final String status;

    private final Integer progressPercent;

    private final String statusDetail;

    private final Instant updateDateTime;

    private MigrationTaskSummary(BuilderImpl builder) {
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.status = builder.status;
        this.progressPercent = builder.progressPercent;
        this.statusDetail = builder.statusDetail;
        this.updateDateTime = builder.updateDateTime;
    }

    /**
     * <p>
     * An AWS resource used for access control. It should uniquely identify the migration tool as it is used for all
     * updates made by the tool.
     * </p>
     * 
     * @return An AWS resource used for access control. It should uniquely identify the migration tool as it is used for
     *         all updates made by the tool.
     */
    public final String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     * </p>
     * 
     * @return Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
     */
    public final String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * Status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the task.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the task.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indication of the percentage completion of the task.
     * </p>
     * 
     * @return Indication of the percentage completion of the task.
     */
    public final Integer progressPercent() {
        return progressPercent;
    }

    /**
     * <p>
     * Detail information of what is being done within the overall status state.
     * </p>
     * 
     * @return Detail information of what is being done within the overall status state.
     */
    public final String statusDetail() {
        return statusDetail;
    }

    /**
     * <p>
     * The timestamp when the task was gathered.
     * </p>
     * 
     * @return The timestamp when the task was gathered.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTaskSummary)) {
            return false;
        }
        MigrationTaskSummary other = (MigrationTaskSummary) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(progressPercent(), other.progressPercent())
                && Objects.equals(statusDetail(), other.statusDetail())
                && Objects.equals(updateDateTime(), other.updateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MigrationTaskSummary").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("Status", statusAsString())
                .add("ProgressPercent", progressPercent()).add("StatusDetail", statusDetail())
                .add("UpdateDateTime", updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ProgressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        case "StatusDetail":
            return Optional.ofNullable(clazz.cast(statusDetail()));
        case "UpdateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressUpdateStream", PROGRESS_UPDATE_STREAM_FIELD);
        map.put("MigrationTaskName", MIGRATION_TASK_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ProgressPercent", PROGRESS_PERCENT_FIELD);
        map.put("StatusDetail", STATUS_DETAIL_FIELD);
        map.put("UpdateDateTime", UPDATE_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MigrationTaskSummary, T> g) {
        return obj -> g.apply((MigrationTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MigrationTaskSummary> {
        /**
         * <p>
         * An AWS resource used for access control. It should uniquely identify the migration tool as it is used for all
         * updates made by the tool.
         * </p>
         * 
         * @param progressUpdateStream
         *        An AWS resource used for access control. It should uniquely identify the migration tool as it is used
         *        for all updates made by the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        Unique identifier that references the migration task. <i>Do not store personal data in this field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * Status of the task.
         * </p>
         * 
         * @param status
         *        Status of the task.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the task.
         * </p>
         * 
         * @param status
         *        Status of the task.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Indication of the percentage completion of the task.
         * </p>
         * 
         * @param progressPercent
         *        Indication of the percentage completion of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Integer progressPercent);

        /**
         * <p>
         * Detail information of what is being done within the overall status state.
         * </p>
         * 
         * @param statusDetail
         *        Detail information of what is being done within the overall status state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetail(String statusDetail);

        /**
         * <p>
         * The timestamp when the task was gathered.
         * </p>
         * 
         * @param updateDateTime
         *        The timestamp when the task was gathered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private String status;

        private Integer progressPercent;

        private String statusDetail;

        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTaskSummary model) {
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            status(model.status);
            progressPercent(model.progressPercent);
            statusDetail(model.statusDetail);
            updateDateTime(model.updateDateTime);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final String getStatusDetail() {
            return statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public MigrationTaskSummary build() {
            return new MigrationTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
