/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTaskUpdatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTaskUpdatesResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationTaskUpdate;

public class ListMigrationTaskUpdatesPublisher
implements SdkPublisher<ListMigrationTaskUpdatesResponse> {
    private final MigrationHubAsyncClient client;
    private final ListMigrationTaskUpdatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMigrationTaskUpdatesPublisher(MigrationHubAsyncClient client, ListMigrationTaskUpdatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMigrationTaskUpdatesPublisher(MigrationHubAsyncClient client, ListMigrationTaskUpdatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMigrationTaskUpdatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMigrationTaskUpdatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MigrationTaskUpdate> migrationTaskUpdateList() {
        Function<ListMigrationTaskUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.migrationTaskUpdateList() != null) {
                return response.migrationTaskUpdateList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMigrationTaskUpdatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMigrationTaskUpdatesResponseFetcher
    implements AsyncPageFetcher<ListMigrationTaskUpdatesResponse> {
        private ListMigrationTaskUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(ListMigrationTaskUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMigrationTaskUpdatesResponse> nextPage(ListMigrationTaskUpdatesResponse previousPage) {
            if (previousPage == null) {
                return ListMigrationTaskUpdatesPublisher.this.client.listMigrationTaskUpdates(ListMigrationTaskUpdatesPublisher.this.firstRequest);
            }
            return ListMigrationTaskUpdatesPublisher.this.client.listMigrationTaskUpdates((ListMigrationTaskUpdatesRequest)((Object)ListMigrationTaskUpdatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

