/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.CreatedArtifact;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse;

public class ListCreatedArtifactsPublisher
implements SdkPublisher<ListCreatedArtifactsResponse> {
    private final MigrationHubAsyncClient client;
    private final ListCreatedArtifactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCreatedArtifactsPublisher(MigrationHubAsyncClient client, ListCreatedArtifactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCreatedArtifactsPublisher(MigrationHubAsyncClient client, ListCreatedArtifactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCreatedArtifactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCreatedArtifactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CreatedArtifact> createdArtifactList() {
        Function<ListCreatedArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.createdArtifactList() != null) {
                return response.createdArtifactList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCreatedArtifactsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCreatedArtifactsResponseFetcher
    implements AsyncPageFetcher<ListCreatedArtifactsResponse> {
        private ListCreatedArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListCreatedArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCreatedArtifactsResponse> nextPage(ListCreatedArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListCreatedArtifactsPublisher.this.client.listCreatedArtifacts(ListCreatedArtifactsPublisher.this.firstRequest);
            }
            return ListCreatedArtifactsPublisher.this.client.listCreatedArtifacts((ListCreatedArtifactsRequest)((Object)ListCreatedArtifactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

