/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.migrationhub.DefaultMigrationHubBaseClientBuilder;
import software.amazon.awssdk.services.migrationhub.DefaultMigrationHubClient;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.MigrationHubClientBuilder;
import software.amazon.awssdk.services.migrationhub.MigrationHubServiceClientConfiguration;
import software.amazon.awssdk.services.migrationhub.endpoints.MigrationHubEndpointProvider;

@SdkInternalApi
final class DefaultMigrationHubClientBuilder
extends DefaultMigrationHubBaseClientBuilder<MigrationHubClientBuilder, MigrationHubClient>
implements MigrationHubClientBuilder {
    DefaultMigrationHubClientBuilder() {
    }

    @Override
    public DefaultMigrationHubClientBuilder endpointProvider(MigrationHubEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MigrationHubClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMigrationHubClientBuilder.validateClientOptions(clientConfiguration);
        MigrationHubServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMigrationHubClient client = new DefaultMigrationHubClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MigrationHubServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MigrationHubServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

