/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.migrationhub.DefaultMigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.DefaultMigrationHubBaseClientBuilder;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClientBuilder;
import software.amazon.awssdk.services.migrationhub.MigrationHubServiceClientConfiguration;
import software.amazon.awssdk.services.migrationhub.endpoints.MigrationHubEndpointProvider;

@SdkInternalApi
final class DefaultMigrationHubAsyncClientBuilder
extends DefaultMigrationHubBaseClientBuilder<MigrationHubAsyncClientBuilder, MigrationHubAsyncClient>
implements MigrationHubAsyncClientBuilder {
    DefaultMigrationHubAsyncClientBuilder() {
    }

    @Override
    public DefaultMigrationHubAsyncClientBuilder endpointProvider(MigrationHubEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MigrationHubAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMigrationHubAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MigrationHubServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMigrationHubAsyncClient client = new DefaultMigrationHubAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MigrationHubServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MigrationHubServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

