/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.migrationhub.MigrationHubClient;
import software.amazon.awssdk.services.migrationhub.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.DryRunOperationException;
import software.amazon.awssdk.services.migrationhub.model.HomeRegionNotSetException;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.InternalServerErrorException;
import software.amazon.awssdk.services.migrationhub.model.InvalidInputException;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubException;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateResponse;
import software.amazon.awssdk.services.migrationhub.model.PolicyErrorException;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesResponse;
import software.amazon.awssdk.services.migrationhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhub.model.ServiceUnavailableException;
import software.amazon.awssdk.services.migrationhub.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable;
import software.amazon.awssdk.services.migrationhub.transform.AssociateCreatedArtifactRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.AssociateDiscoveredResourceRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.CreateProgressUpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DeleteProgressUpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeApplicationStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DescribeMigrationTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateCreatedArtifactRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.DisassociateDiscoveredResourceRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ImportMigrationTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListApplicationStatesRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListCreatedArtifactsRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListMigrationTasksRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.ListProgressUpdateStreamsRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyApplicationStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.NotifyMigrationTaskStateRequestMarshaller;
import software.amazon.awssdk.services.migrationhub.transform.PutResourceAttributesRequestMarshaller;

@SdkInternalApi
final class DefaultMigrationHubClient
implements MigrationHubClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMigrationHubClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "mgh";
    }

    @Override
    public AssociateCreatedArtifactResponse associateCreatedArtifact(AssociateCreatedArtifactRequest associateCreatedArtifactRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateCreatedArtifactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateCreatedArtifactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateCreatedArtifact").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateCreatedArtifactRequest).withMarshaller((Marshaller)new AssociateCreatedArtifactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AssociateDiscoveredResourceResponse associateDiscoveredResource(AssociateDiscoveredResourceRequest associateDiscoveredResourceRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateDiscoveredResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateDiscoveredResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDiscoveredResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateDiscoveredResourceRequest).withMarshaller((Marshaller)new AssociateDiscoveredResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateProgressUpdateStreamResponse createProgressUpdateStream(CreateProgressUpdateStreamRequest createProgressUpdateStreamRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProgressUpdateStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateProgressUpdateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProgressUpdateStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProgressUpdateStreamRequest).withMarshaller((Marshaller)new CreateProgressUpdateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteProgressUpdateStreamResponse deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest deleteProgressUpdateStreamRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProgressUpdateStreamResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteProgressUpdateStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProgressUpdateStream").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProgressUpdateStreamRequest).withMarshaller((Marshaller)new DeleteProgressUpdateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeApplicationStateResponse describeApplicationState(DescribeApplicationStateRequest describeApplicationStateRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeApplicationStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicationStateRequest).withMarshaller((Marshaller)new DescribeApplicationStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeMigrationTaskResponse describeMigrationTask(DescribeMigrationTaskRequest describeMigrationTaskRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMigrationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeMigrationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMigrationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMigrationTaskRequest).withMarshaller((Marshaller)new DescribeMigrationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateCreatedArtifactResponse disassociateCreatedArtifact(DisassociateCreatedArtifactRequest disassociateCreatedArtifactRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateCreatedArtifactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateCreatedArtifactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateCreatedArtifact").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateCreatedArtifactRequest).withMarshaller((Marshaller)new DisassociateCreatedArtifactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateDiscoveredResourceResponse disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest disassociateDiscoveredResourceRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateDiscoveredResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateDiscoveredResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDiscoveredResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateDiscoveredResourceRequest).withMarshaller((Marshaller)new DisassociateDiscoveredResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ImportMigrationTaskResponse importMigrationTask(ImportMigrationTaskRequest importMigrationTaskRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportMigrationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ImportMigrationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportMigrationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importMigrationTaskRequest).withMarshaller((Marshaller)new ImportMigrationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListApplicationStatesResponse listApplicationStates(ListApplicationStatesRequest listApplicationStatesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationStatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListApplicationStatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationStates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationStatesRequest).withMarshaller((Marshaller)new ListApplicationStatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListApplicationStatesIterable listApplicationStatesPaginator(ListApplicationStatesRequest listApplicationStatesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListApplicationStatesIterable(this, this.applyPaginatorUserAgent(listApplicationStatesRequest));
    }

    @Override
    public ListCreatedArtifactsResponse listCreatedArtifacts(ListCreatedArtifactsRequest listCreatedArtifactsRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCreatedArtifactsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListCreatedArtifactsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCreatedArtifacts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCreatedArtifactsRequest).withMarshaller((Marshaller)new ListCreatedArtifactsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListCreatedArtifactsIterable listCreatedArtifactsPaginator(ListCreatedArtifactsRequest listCreatedArtifactsRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListCreatedArtifactsIterable(this, this.applyPaginatorUserAgent(listCreatedArtifactsRequest));
    }

    @Override
    public ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDiscoveredResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDiscoveredResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDiscoveredResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDiscoveredResourcesRequest).withMarshaller((Marshaller)new ListDiscoveredResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDiscoveredResourcesIterable listDiscoveredResourcesPaginator(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListDiscoveredResourcesIterable(this, this.applyPaginatorUserAgent(listDiscoveredResourcesRequest));
    }

    @Override
    public ListMigrationTasksResponse listMigrationTasks(ListMigrationTasksRequest listMigrationTasksRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMigrationTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListMigrationTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMigrationTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMigrationTasksRequest).withMarshaller((Marshaller)new ListMigrationTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMigrationTasksIterable listMigrationTasksPaginator(ListMigrationTasksRequest listMigrationTasksRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListMigrationTasksIterable(this, this.applyPaginatorUserAgent(listMigrationTasksRequest));
    }

    @Override
    public ListProgressUpdateStreamsResponse listProgressUpdateStreams(ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProgressUpdateStreamsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProgressUpdateStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProgressUpdateStreams").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProgressUpdateStreamsRequest).withMarshaller((Marshaller)new ListProgressUpdateStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProgressUpdateStreamsIterable listProgressUpdateStreamsPaginator(ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListProgressUpdateStreamsIterable(this, this.applyPaginatorUserAgent(listProgressUpdateStreamsRequest));
    }

    @Override
    public NotifyApplicationStateResponse notifyApplicationState(NotifyApplicationStateRequest notifyApplicationStateRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyApplicationStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (NotifyApplicationStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyApplicationState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyApplicationStateRequest).withMarshaller((Marshaller)new NotifyApplicationStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public NotifyMigrationTaskStateResponse notifyMigrationTaskState(NotifyMigrationTaskStateRequest notifyMigrationTaskStateRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyMigrationTaskStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (NotifyMigrationTaskStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyMigrationTaskState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyMigrationTaskStateRequest).withMarshaller((Marshaller)new NotifyMigrationTaskStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutResourceAttributesResponse putResourceAttributes(PutResourceAttributesRequest putResourceAttributesRequest) throws AccessDeniedException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourceAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutResourceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourceAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putResourceAttributesRequest).withMarshaller((Marshaller)new PutResourceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MigrationHubException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedOperation").exceptionBuilderSupplier(UnauthorizedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyErrorException").exceptionBuilderSupplier(PolicyErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").exceptionBuilderSupplier(HomeRegionNotSetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DryRunOperation").exceptionBuilderSupplier(DryRunOperationException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends MigrationHubRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.49").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MigrationHubRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

