/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse;
import software.amazon.awssdk.services.mgn.model.ManagedAccount;

public class ListManagedAccountsPublisher
implements SdkPublisher<ListManagedAccountsResponse> {
    private final MgnAsyncClient client;
    private final ListManagedAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedAccountsPublisher(MgnAsyncClient client, ListManagedAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedAccountsPublisher(MgnAsyncClient client, ListManagedAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedAccount> items() {
        Function<ListManagedAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedAccountsResponseFetcher
    implements AsyncPageFetcher<ListManagedAccountsResponse> {
        private ListManagedAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedAccountsResponse> nextPage(ListManagedAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedAccountsPublisher.this.client.listManagedAccounts(ListManagedAccountsPublisher.this.firstRequest);
            }
            return ListManagedAccountsPublisher.this.client.listManagedAccounts((ListManagedAccountsRequest)((Object)ListManagedAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

