/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataReplicationState {
    STOPPED("STOPPED"),
    INITIATING("INITIATING"),
    INITIAL_SYNC("INITIAL_SYNC"),
    BACKLOG("BACKLOG"),
    CREATING_SNAPSHOT("CREATING_SNAPSHOT"),
    CONTINUOUS("CONTINUOUS"),
    PAUSED("PAUSED"),
    RESCAN("RESCAN"),
    STALLED("STALLED"),
    DISCONNECTED("DISCONNECTED"),
    PENDING_SNAPSHOT_SHIPPING("PENDING_SNAPSHOT_SHIPPING"),
    SHIPPING_SNAPSHOT("SHIPPING_SNAPSHOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataReplicationState> VALUE_MAP;
    private final String value;

    private DataReplicationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataReplicationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataReplicationState> knownValues() {
        EnumSet<DataReplicationState> knownValues = EnumSet.allOf(DataReplicationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataReplicationState.class, DataReplicationState::toString);
    }
}

