/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse;
import software.amazon.awssdk.services.mgn.model.ManagedAccount;

public class ListManagedAccountsIterable
implements SdkIterable<ListManagedAccountsResponse> {
    private final MgnClient client;
    private final ListManagedAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedAccountsIterable(MgnClient client, ListManagedAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedAccountsResponseFetcher();
    }

    public Iterator<ListManagedAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedAccount> items() {
        Function<ListManagedAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedAccountsResponseFetcher
    implements SyncPageFetcher<ListManagedAccountsResponse> {
        private ListManagedAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedAccountsResponse nextPage(ListManagedAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedAccountsIterable.this.client.listManagedAccounts(ListManagedAccountsIterable.this.firstRequest);
            }
            return ListManagedAccountsIterable.this.client.listManagedAccounts((ListManagedAccountsRequest)((Object)ListManagedAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

