/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.ImportStatus;
import software.amazon.awssdk.services.mgn.model.ImportTaskSummary;
import software.amazon.awssdk.services.mgn.model.S3BucketSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportTask> {
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationDateTime").getter(ImportTask.getter(ImportTask::creationDateTime)).setter(ImportTask.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endDateTime").getter(ImportTask.getter(ImportTask::endDateTime)).setter(ImportTask.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importID").getter(ImportTask.getter(ImportTask::importID)).setter(ImportTask.setter(Builder::importID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importID").build()}).build();
    private static final SdkField<Float> PROGRESS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("progressPercentage").getter(ImportTask.getter(ImportTask::progressPercentage)).setter(ImportTask.setter(Builder::progressPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercentage").build()}).build();
    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3BucketSource").getter(ImportTask.getter(ImportTask::s3BucketSource)).setter(ImportTask.setter(Builder::s3BucketSource)).constructor(S3BucketSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketSource").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImportTask.getter(ImportTask::statusAsString)).setter(ImportTask.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ImportTaskSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summary").getter(ImportTask.getter(ImportTask::summary)).setter(ImportTask.setter(Builder::summary)).constructor(ImportTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_TIME_FIELD, END_DATE_TIME_FIELD, IMPORT_ID_FIELD, PROGRESS_PERCENTAGE_FIELD, S3_BUCKET_SOURCE_FIELD, STATUS_FIELD, SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String creationDateTime;
    private final String endDateTime;
    private final String importID;
    private final Float progressPercentage;
    private final S3BucketSource s3BucketSource;
    private final String status;
    private final ImportTaskSummary summary;

    private ImportTask(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.endDateTime = builder.endDateTime;
        this.importID = builder.importID;
        this.progressPercentage = builder.progressPercentage;
        this.s3BucketSource = builder.s3BucketSource;
        this.status = builder.status;
        this.summary = builder.summary;
    }

    public final String creationDateTime() {
        return this.creationDateTime;
    }

    public final String endDateTime() {
        return this.endDateTime;
    }

    public final String importID() {
        return this.importID;
    }

    public final Float progressPercentage() {
        return this.progressPercentage;
    }

    public final S3BucketSource s3BucketSource() {
        return this.s3BucketSource;
    }

    public final ImportStatus status() {
        return ImportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ImportTaskSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importID());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTask)) {
            return false;
        }
        ImportTask other = (ImportTask)obj;
        return Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.importID(), other.importID()) && Objects.equals(this.progressPercentage(), other.progressPercentage()) && Objects.equals(this.s3BucketSource(), other.s3BucketSource()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"ImportTask").add("CreationDateTime", (Object)this.creationDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("ImportID", (Object)this.importID()).add("ProgressPercentage", (Object)this.progressPercentage()).add("S3BucketSource", (Object)this.s3BucketSource()).add("Status", (Object)this.statusAsString()).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "importID": {
                return Optional.ofNullable(clazz.cast(this.importID()));
            }
            case "progressPercentage": {
                return Optional.ofNullable(clazz.cast(this.progressPercentage()));
            }
            case "s3BucketSource": {
                return Optional.ofNullable(clazz.cast(this.s3BucketSource()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTask, T> g) {
        return obj -> g.apply((ImportTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String creationDateTime;
        private String endDateTime;
        private String importID;
        private Float progressPercentage;
        private S3BucketSource s3BucketSource;
        private String status;
        private ImportTaskSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTask model) {
            this.creationDateTime(model.creationDateTime);
            this.endDateTime(model.endDateTime);
            this.importID(model.importID);
            this.progressPercentage(model.progressPercentage);
            this.s3BucketSource(model.s3BucketSource);
            this.status(model.status);
            this.summary(model.summary);
        }

        public final String getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getImportID() {
            return this.importID;
        }

        public final void setImportID(String importID) {
            this.importID = importID;
        }

        @Override
        public final Builder importID(String importID) {
            this.importID = importID;
            return this;
        }

        public final Float getProgressPercentage() {
            return this.progressPercentage;
        }

        public final void setProgressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return this.s3BucketSource != null ? this.s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ImportTaskSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(ImportTaskSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(ImportTaskSummary summary) {
            this.summary = summary;
            return this;
        }

        public ImportTask build() {
            return new ImportTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportTask> {
        public Builder creationDateTime(String var1);

        public Builder endDateTime(String var1);

        public Builder importID(String var1);

        public Builder progressPercentage(Float var1);

        public Builder s3BucketSource(S3BucketSource var1);

        default public Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return this.s3BucketSource((S3BucketSource)((S3BucketSource.Builder)S3BucketSource.builder().applyMutation(s3BucketSource)).build());
        }

        public Builder status(String var1);

        public Builder status(ImportStatus var1);

        public Builder summary(ImportTaskSummary var1);

        default public Builder summary(Consumer<ImportTaskSummary.Builder> summary) {
            return this.summary((ImportTaskSummary)((ImportTaskSummary.Builder)ImportTaskSummary.builder().applyMutation(summary)).build());
        }
    }
}

