/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.ApplicationIDsCopier;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateApplicationsRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, DisassociateApplicationsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountID").getter(DisassociateApplicationsRequest.getter(DisassociateApplicationsRequest::accountID)).setter(DisassociateApplicationsRequest.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()}).build();
    private static final SdkField<List<String>> APPLICATION_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationIDs").getter(DisassociateApplicationsRequest.getter(DisassociateApplicationsRequest::applicationIDs)).setter(DisassociateApplicationsRequest.setter(Builder::applicationIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WAVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("waveID").getter(DisassociateApplicationsRequest.getter(DisassociateApplicationsRequest::waveID)).setter(DisassociateApplicationsRequest.setter(Builder::waveID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, APPLICATION_I_DS_FIELD, WAVE_ID_FIELD));
    private final String accountID;
    private final List<String> applicationIDs;
    private final String waveID;

    private DisassociateApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.applicationIDs = builder.applicationIDs;
        this.waveID = builder.waveID;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final boolean hasApplicationIDs() {
        return this.applicationIDs != null && !(this.applicationIDs instanceof SdkAutoConstructList);
    }

    public final List<String> applicationIDs() {
        return this.applicationIDs;
    }

    public final String waveID() {
        return this.waveID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationIDs() ? this.applicationIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waveID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateApplicationsRequest)) {
            return false;
        }
        DisassociateApplicationsRequest other = (DisassociateApplicationsRequest)((Object)obj);
        return Objects.equals(this.accountID(), other.accountID()) && this.hasApplicationIDs() == other.hasApplicationIDs() && Objects.equals(this.applicationIDs(), other.applicationIDs()) && Objects.equals(this.waveID(), other.waveID());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateApplicationsRequest").add("AccountID", (Object)this.accountID()).add("ApplicationIDs", this.hasApplicationIDs() ? this.applicationIDs() : null).add("WaveID", (Object)this.waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "applicationIDs": {
                return Optional.ofNullable(clazz.cast(this.applicationIDs()));
            }
            case "waveID": {
                return Optional.ofNullable(clazz.cast(this.waveID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateApplicationsRequest, T> g) {
        return obj -> g.apply((DisassociateApplicationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String accountID;
        private List<String> applicationIDs = DefaultSdkAutoConstructList.getInstance();
        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateApplicationsRequest model) {
            super(model);
            this.accountID(model.accountID);
            this.applicationIDs(model.applicationIDs);
            this.waveID(model.waveID);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final Collection<String> getApplicationIDs() {
            if (this.applicationIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationIDs;
        }

        public final void setApplicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = ApplicationIDsCopier.copy(applicationIDs);
        }

        @Override
        public final Builder applicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = ApplicationIDsCopier.copy(applicationIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIDs(String ... applicationIDs) {
            this.applicationIDs(Arrays.asList(applicationIDs));
            return this;
        }

        public final String getWaveID() {
            return this.waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateApplicationsRequest build() {
            return new DisassociateApplicationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateApplicationsRequest> {
        public Builder accountID(String var1);

        public Builder applicationIDs(Collection<String> var1);

        public Builder applicationIDs(String ... var1);

        public Builder waveID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

