/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse;
import software.amazon.awssdk.services.mgn.model.VcenterClient;

public class DescribeVcenterClientsIterable
implements SdkIterable<DescribeVcenterClientsResponse> {
    private final MgnClient client;
    private final DescribeVcenterClientsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVcenterClientsIterable(MgnClient client, DescribeVcenterClientsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVcenterClientsResponseFetcher();
    }

    public Iterator<DescribeVcenterClientsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VcenterClient> items() {
        Function<DescribeVcenterClientsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVcenterClientsResponseFetcher
    implements SyncPageFetcher<DescribeVcenterClientsResponse> {
        private DescribeVcenterClientsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVcenterClientsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVcenterClientsResponse nextPage(DescribeVcenterClientsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVcenterClientsIterable.this.client.describeVcenterClients(DescribeVcenterClientsIterable.this.firstRequest);
            }
            return DescribeVcenterClientsIterable.this.client.describeVcenterClients((DescribeVcenterClientsRequest)((Object)DescribeVcenterClientsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

