/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.model.ExportTaskError;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse;

public class ListExportErrorsPublisher
implements SdkPublisher<ListExportErrorsResponse> {
    private final MgnAsyncClient client;
    private final ListExportErrorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExportErrorsPublisher(MgnAsyncClient client, ListExportErrorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExportErrorsPublisher(MgnAsyncClient client, ListExportErrorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExportErrorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExportErrorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExportTaskError> items() {
        Function<ListExportErrorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExportErrorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExportErrorsResponseFetcher
    implements AsyncPageFetcher<ListExportErrorsResponse> {
        private ListExportErrorsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportErrorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExportErrorsResponse> nextPage(ListExportErrorsResponse previousPage) {
            if (previousPage == null) {
                return ListExportErrorsPublisher.this.client.listExportErrors(ListExportErrorsPublisher.this.firstRequest);
            }
            return ListExportErrorsPublisher.this.client.listExportErrors((ListExportErrorsRequest)((Object)ListExportErrorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

