/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.model.ListWavesRequest;
import software.amazon.awssdk.services.mgn.model.ListWavesResponse;
import software.amazon.awssdk.services.mgn.model.Wave;

public class ListWavesPublisher
implements SdkPublisher<ListWavesResponse> {
    private final MgnAsyncClient client;
    private final ListWavesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWavesPublisher(MgnAsyncClient client, ListWavesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWavesPublisher(MgnAsyncClient client, ListWavesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWavesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWavesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Wave> items() {
        Function<ListWavesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWavesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWavesResponseFetcher
    implements AsyncPageFetcher<ListWavesResponse> {
        private ListWavesResponseFetcher() {
        }

        public boolean hasNextPage(ListWavesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWavesResponse> nextPage(ListWavesResponse previousPage) {
            if (previousPage == null) {
                return ListWavesPublisher.this.client.listWaves(ListWavesPublisher.this.firstRequest);
            }
            return ListWavesPublisher.this.client.listWaves((ListWavesRequest)((Object)ListWavesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

