/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.SsmDocumentParametersCopier;
import software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceServerActionDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceServerActionDocument> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionID").getter(SourceServerActionDocument.getter(SourceServerActionDocument::actionID)).setter(SourceServerActionDocument.setter(Builder::actionID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionID").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(SourceServerActionDocument.getter(SourceServerActionDocument::actionName)).setter(SourceServerActionDocument.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(SourceServerActionDocument.getter(SourceServerActionDocument::active)).setter(SourceServerActionDocument.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<String> DOCUMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentIdentifier").getter(SourceServerActionDocument.getter(SourceServerActionDocument::documentIdentifier)).setter(SourceServerActionDocument.setter(Builder::documentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentIdentifier").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentVersion").getter(SourceServerActionDocument.getter(SourceServerActionDocument::documentVersion)).setter(SourceServerActionDocument.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentVersion").build()}).build();
    private static final SdkField<Boolean> MUST_SUCCEED_FOR_CUTOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("mustSucceedForCutover").getter(SourceServerActionDocument.getter(SourceServerActionDocument::mustSucceedForCutover)).setter(SourceServerActionDocument.setter(Builder::mustSucceedForCutover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mustSucceedForCutover").build()}).build();
    private static final SdkField<Integer> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("order").getter(SourceServerActionDocument.getter(SourceServerActionDocument::order)).setter(SourceServerActionDocument.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final SdkField<Map<String, List<SsmParameterStoreParameter>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(SourceServerActionDocument.getter(SourceServerActionDocument::parameters)).setter(SourceServerActionDocument.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmParameterStoreParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutSeconds").getter(SourceServerActionDocument.getter(SourceServerActionDocument::timeoutSeconds)).setter(SourceServerActionDocument.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, ACTION_NAME_FIELD, ACTIVE_FIELD, DOCUMENT_IDENTIFIER_FIELD, DOCUMENT_VERSION_FIELD, MUST_SUCCEED_FOR_CUTOVER_FIELD, ORDER_FIELD, PARAMETERS_FIELD, TIMEOUT_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionID;
    private final String actionName;
    private final Boolean active;
    private final String documentIdentifier;
    private final String documentVersion;
    private final Boolean mustSucceedForCutover;
    private final Integer order;
    private final Map<String, List<SsmParameterStoreParameter>> parameters;
    private final Integer timeoutSeconds;

    private SourceServerActionDocument(BuilderImpl builder) {
        this.actionID = builder.actionID;
        this.actionName = builder.actionName;
        this.active = builder.active;
        this.documentIdentifier = builder.documentIdentifier;
        this.documentVersion = builder.documentVersion;
        this.mustSucceedForCutover = builder.mustSucceedForCutover;
        this.order = builder.order;
        this.parameters = builder.parameters;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    public final String actionID() {
        return this.actionID;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final Boolean active() {
        return this.active;
    }

    public final String documentIdentifier() {
        return this.documentIdentifier;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final Boolean mustSucceedForCutover() {
        return this.mustSucceedForCutover;
    }

    public final Integer order() {
        return this.order;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<SsmParameterStoreParameter>> parameters() {
        return this.parameters;
    }

    public final Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionID());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.mustSucceedForCutover());
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceServerActionDocument)) {
            return false;
        }
        SourceServerActionDocument other = (SourceServerActionDocument)obj;
        return Objects.equals(this.actionID(), other.actionID()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.documentIdentifier(), other.documentIdentifier()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.mustSucceedForCutover(), other.mustSucceedForCutover()) && Objects.equals(this.order(), other.order()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"SourceServerActionDocument").add("ActionID", (Object)this.actionID()).add("ActionName", (Object)this.actionName()).add("Active", (Object)this.active()).add("DocumentIdentifier", (Object)this.documentIdentifier()).add("DocumentVersion", (Object)this.documentVersion()).add("MustSucceedForCutover", (Object)this.mustSucceedForCutover()).add("Order", (Object)this.order()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("TimeoutSeconds", (Object)this.timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionID": {
                return Optional.ofNullable(clazz.cast(this.actionID()));
            }
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "documentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.documentIdentifier()));
            }
            case "documentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "mustSucceedForCutover": {
                return Optional.ofNullable(clazz.cast(this.mustSucceedForCutover()));
            }
            case "order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "timeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceServerActionDocument, T> g) {
        return obj -> g.apply((SourceServerActionDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionID;
        private String actionName;
        private Boolean active;
        private String documentIdentifier;
        private String documentVersion;
        private Boolean mustSucceedForCutover;
        private Integer order;
        private Map<String, List<SsmParameterStoreParameter>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceServerActionDocument model) {
            this.actionID(model.actionID);
            this.actionName(model.actionName);
            this.active(model.active);
            this.documentIdentifier(model.documentIdentifier);
            this.documentVersion(model.documentVersion);
            this.mustSucceedForCutover(model.mustSucceedForCutover);
            this.order(model.order);
            this.parameters(model.parameters);
            this.timeoutSeconds(model.timeoutSeconds);
        }

        public final String getActionID() {
            return this.actionID;
        }

        public final void setActionID(String actionID) {
            this.actionID = actionID;
        }

        @Override
        public final Builder actionID(String actionID) {
            this.actionID = actionID;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getDocumentIdentifier() {
            return this.documentIdentifier;
        }

        public final void setDocumentIdentifier(String documentIdentifier) {
            this.documentIdentifier = documentIdentifier;
        }

        @Override
        public final Builder documentIdentifier(String documentIdentifier) {
            this.documentIdentifier = documentIdentifier;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Boolean getMustSucceedForCutover() {
            return this.mustSucceedForCutover;
        }

        public final void setMustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
        }

        @Override
        public final Builder mustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
            return this;
        }

        public final Integer getOrder() {
            return this.order;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final Map<String, List<SsmParameterStoreParameter.Builder>> getParameters() {
            Map<String, List<SsmParameterStoreParameter.Builder>> result = SsmDocumentParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, ? extends Collection<SsmParameterStoreParameter.BuilderImpl>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public SourceServerActionDocument build() {
            return new SourceServerActionDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceServerActionDocument> {
        public Builder actionID(String var1);

        public Builder actionName(String var1);

        public Builder active(Boolean var1);

        public Builder documentIdentifier(String var1);

        public Builder documentVersion(String var1);

        public Builder mustSucceedForCutover(Boolean var1);

        public Builder order(Integer var1);

        public Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> var1);

        public Builder timeoutSeconds(Integer var1);
    }
}

