/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse;
import software.amazon.awssdk.services.mgn.model.SourceServerActionDocument;

public class ListSourceServerActionsPublisher
implements SdkPublisher<ListSourceServerActionsResponse> {
    private final MgnAsyncClient client;
    private final ListSourceServerActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceServerActionsPublisher(MgnAsyncClient client, ListSourceServerActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceServerActionsPublisher(MgnAsyncClient client, ListSourceServerActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceServerActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceServerActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceServerActionDocument> items() {
        Function<ListSourceServerActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceServerActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceServerActionsResponseFetcher
    implements AsyncPageFetcher<ListSourceServerActionsResponse> {
        private ListSourceServerActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceServerActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceServerActionsResponse> nextPage(ListSourceServerActionsResponse previousPage) {
            if (previousPage == null) {
                return ListSourceServerActionsPublisher.this.client.listSourceServerActions(ListSourceServerActionsPublisher.this.firstRequest);
            }
            return ListSourceServerActionsPublisher.this.client.listSourceServerActions((ListSourceServerActionsRequest)((Object)ListSourceServerActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

