/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse;
import software.amazon.awssdk.services.mgn.model.SourceServerActionDocument;

public class ListSourceServerActionsIterable
implements SdkIterable<ListSourceServerActionsResponse> {
    private final MgnClient client;
    private final ListSourceServerActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceServerActionsIterable(MgnClient client, ListSourceServerActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSourceServerActionsResponseFetcher();
    }

    public Iterator<ListSourceServerActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SourceServerActionDocument> items() {
        Function<ListSourceServerActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceServerActionsResponseFetcher
    implements SyncPageFetcher<ListSourceServerActionsResponse> {
        private ListSourceServerActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceServerActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceServerActionsResponse nextPage(ListSourceServerActionsResponse previousPage) {
            if (previousPage == null) {
                return ListSourceServerActionsIterable.this.client.listSourceServerActions(ListSourceServerActionsIterable.this.firstRequest);
            }
            return ListSourceServerActionsIterable.this.client.listSourceServerActions((ListSourceServerActionsRequest)((Object)ListSourceServerActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

