/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataReplicationState {
    STOPPED("STOPPED"),
    INITIATING("INITIATING"),
    INITIAL_SYNC("INITIAL_SYNC"),
    BACKLOG("BACKLOG"),
    CREATING_SNAPSHOT("CREATING_SNAPSHOT"),
    CONTINUOUS("CONTINUOUS"),
    PAUSED("PAUSED"),
    RESCAN("RESCAN"),
    STALLED("STALLED"),
    DISCONNECTED("DISCONNECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataReplicationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataReplicationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataReplicationState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataReplicationState> knownValues() {
        return Stream.of(DataReplicationState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

