/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.Tag;
import software.amazon.awssdk.services.memorydb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySnapshotRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceSnapshotName").getter(CopySnapshotRequest.getter(CopySnapshotRequest::sourceSnapshotName)).setter(CopySnapshotRequest.setter(Builder::sourceSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotName").build()}).build();
    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetSnapshotName").getter(CopySnapshotRequest.getter(CopySnapshotRequest::targetSnapshotName)).setter(CopySnapshotRequest.setter(Builder::targetSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSnapshotName").build()}).build();
    private static final SdkField<String> TARGET_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetBucket").getter(CopySnapshotRequest.getter(CopySnapshotRequest::targetBucket)).setter(CopySnapshotRequest.setter(Builder::targetBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBucket").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CopySnapshotRequest.getter(CopySnapshotRequest::kmsKeyId)).setter(CopySnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CopySnapshotRequest.getter(CopySnapshotRequest::tags)).setter(CopySnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD, TARGET_SNAPSHOT_NAME_FIELD, TARGET_BUCKET_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopySnapshotRequest.memberNameToFieldInitializer();
    private final String sourceSnapshotName;
    private final String targetSnapshotName;
    private final String targetBucket;
    private final String kmsKeyId;
    private final List<Tag> tags;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.targetBucket = builder.targetBucket;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
    }

    public final String sourceSnapshotName() {
        return this.sourceSnapshotName;
    }

    public final String targetSnapshotName() {
        return this.targetSnapshotName;
    }

    public final String targetBucket() {
        return this.targetBucket;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceSnapshotName(), other.sourceSnapshotName()) && Objects.equals(this.targetSnapshotName(), other.targetSnapshotName()) && Objects.equals(this.targetBucket(), other.targetBucket()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CopySnapshotRequest").add("SourceSnapshotName", (Object)this.sourceSnapshotName()).add("TargetSnapshotName", (Object)this.targetSnapshotName()).add("TargetBucket", (Object)this.targetBucket()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotName()));
            }
            case "TargetSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.targetSnapshotName()));
            }
            case "TargetBucket": {
                return Optional.ofNullable(clazz.cast(this.targetBucket()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceSnapshotName", SOURCE_SNAPSHOT_NAME_FIELD);
        map.put("TargetSnapshotName", TARGET_SNAPSHOT_NAME_FIELD);
        map.put("TargetBucket", TARGET_BUCKET_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String sourceSnapshotName;
        private String targetSnapshotName;
        private String targetBucket;
        private String kmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            this.sourceSnapshotName(model.sourceSnapshotName);
            this.targetSnapshotName(model.targetSnapshotName);
            this.targetBucket(model.targetBucket);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
        }

        public final String getSourceSnapshotName() {
            return this.sourceSnapshotName;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final String getTargetSnapshotName() {
            return this.targetSnapshotName;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final String getTargetBucket() {
            return this.targetBucket;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder sourceSnapshotName(String var1);

        public Builder targetSnapshotName(String var1);

        public Builder targetBucket(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

