/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateStatus;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceUpdate> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(ServiceUpdate.getter(ServiceUpdate::clusterName)).setter(ServiceUpdate.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateName)).setter(ServiceUpdate.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReleaseDate").getter(ServiceUpdate.getter(ServiceUpdate::releaseDate)).setter(ServiceUpdate.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ServiceUpdate.getter(ServiceUpdate::description)).setter(ServiceUpdate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ServiceUpdate.getter(ServiceUpdate::statusAsString)).setter(ServiceUpdate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ServiceUpdate.getter(ServiceUpdate::typeAsString)).setter(ServiceUpdate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ServiceUpdate.getter(ServiceUpdate::engine)).setter(ServiceUpdate.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> NODES_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodesUpdated").getter(ServiceUpdate.getter(ServiceUpdate::nodesUpdated)).setter(ServiceUpdate.setter(Builder::nodesUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodesUpdated").build()}).build();
    private static final SdkField<Instant> AUTO_UPDATE_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AutoUpdateStartDate").getter(ServiceUpdate.getter(ServiceUpdate::autoUpdateStartDate)).setter(ServiceUpdate.setter(Builder::autoUpdateStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdateStartDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, SERVICE_UPDATE_NAME_FIELD, RELEASE_DATE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TYPE_FIELD, ENGINE_FIELD, NODES_UPDATED_FIELD, AUTO_UPDATE_START_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterName", CLUSTER_NAME_FIELD);
            this.put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
            this.put("ReleaseDate", RELEASE_DATE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Engine", ENGINE_FIELD);
            this.put("NodesUpdated", NODES_UPDATED_FIELD);
            this.put("AutoUpdateStartDate", AUTO_UPDATE_START_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String serviceUpdateName;
    private final Instant releaseDate;
    private final String description;
    private final String status;
    private final String type;
    private final String engine;
    private final String nodesUpdated;
    private final Instant autoUpdateStartDate;

    private ServiceUpdate(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.serviceUpdateName = builder.serviceUpdateName;
        this.releaseDate = builder.releaseDate;
        this.description = builder.description;
        this.status = builder.status;
        this.type = builder.type;
        this.engine = builder.engine;
        this.nodesUpdated = builder.nodesUpdated;
        this.autoUpdateStartDate = builder.autoUpdateStartDate;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public final Instant releaseDate() {
        return this.releaseDate;
    }

    public final String description() {
        return this.description;
    }

    public final ServiceUpdateStatus status() {
        return ServiceUpdateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ServiceUpdateType type() {
        return ServiceUpdateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String engine() {
        return this.engine;
    }

    public final String nodesUpdated() {
        return this.nodesUpdated;
    }

    public final Instant autoUpdateStartDate() {
        return this.autoUpdateStartDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodesUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdateStartDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceUpdate)) {
            return false;
        }
        ServiceUpdate other = (ServiceUpdate)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && Objects.equals(this.releaseDate(), other.releaseDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.nodesUpdated(), other.nodesUpdated()) && Objects.equals(this.autoUpdateStartDate(), other.autoUpdateStartDate());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceUpdate").add("ClusterName", (Object)this.clusterName()).add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("ReleaseDate", (Object)this.releaseDate()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("Engine", (Object)this.engine()).add("NodesUpdated", (Object)this.nodesUpdated()).add("AutoUpdateStartDate", (Object)this.autoUpdateStartDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "ReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "NodesUpdated": {
                return Optional.ofNullable(clazz.cast(this.nodesUpdated()));
            }
            case "AutoUpdateStartDate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdateStartDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceUpdate, T> g) {
        return obj -> g.apply((ServiceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String serviceUpdateName;
        private Instant releaseDate;
        private String description;
        private String status;
        private String type;
        private String engine;
        private String nodesUpdated;
        private Instant autoUpdateStartDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceUpdate model) {
            this.clusterName(model.clusterName);
            this.serviceUpdateName(model.serviceUpdateName);
            this.releaseDate(model.releaseDate);
            this.description(model.description);
            this.status(model.status);
            this.type(model.type);
            this.engine(model.engine);
            this.nodesUpdated(model.nodesUpdated);
            this.autoUpdateStartDate(model.autoUpdateStartDate);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final Instant getReleaseDate() {
            return this.releaseDate;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceUpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ServiceUpdateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getNodesUpdated() {
            return this.nodesUpdated;
        }

        public final void setNodesUpdated(String nodesUpdated) {
            this.nodesUpdated = nodesUpdated;
        }

        @Override
        public final Builder nodesUpdated(String nodesUpdated) {
            this.nodesUpdated = nodesUpdated;
            return this;
        }

        public final Instant getAutoUpdateStartDate() {
            return this.autoUpdateStartDate;
        }

        public final void setAutoUpdateStartDate(Instant autoUpdateStartDate) {
            this.autoUpdateStartDate = autoUpdateStartDate;
        }

        @Override
        public final Builder autoUpdateStartDate(Instant autoUpdateStartDate) {
            this.autoUpdateStartDate = autoUpdateStartDate;
            return this;
        }

        public ServiceUpdate build() {
            return new ServiceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceUpdate> {
        public Builder clusterName(String var1);

        public Builder serviceUpdateName(String var1);

        public Builder releaseDate(Instant var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ServiceUpdateStatus var1);

        public Builder type(String var1);

        public Builder type(ServiceUpdateType var1);

        public Builder engine(String var1);

        public Builder nodesUpdated(String var1);

        public Builder autoUpdateStartDate(Instant var1);
    }
}

