/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Parameter.getter(Parameter::name)).setter(Parameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Parameter.getter(Parameter::value)).setter(Parameter.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Parameter.getter(Parameter::description)).setter(Parameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(Parameter.getter(Parameter::dataType)).setter(Parameter.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedValues").getter(Parameter.getter(Parameter::allowedValues)).setter(Parameter.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()}).build();
    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumEngineVersion").getter(Parameter.getter(Parameter::minimumEngineVersion)).setter(Parameter.setter(Builder::minimumEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD, DESCRIPTION_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, MINIMUM_ENGINE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Value", VALUE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DataType", DATA_TYPE_FIELD);
            this.put("AllowedValues", ALLOWED_VALUES_FIELD);
            this.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String value;
    private final String description;
    private final String dataType;
    private final String allowedValues;
    private final String minimumEngineVersion;

    private Parameter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.description = builder.description;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.minimumEngineVersion = builder.minimumEngineVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public final String description() {
        return this.description;
    }

    public final String dataType() {
        return this.dataType;
    }

    public final String allowedValues() {
        return this.allowedValues;
    }

    public final String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Parameter").add("Name", (Object)this.name()).add("Value", (Object)this.value()).add("Description", (Object)this.description()).add("DataType", (Object)this.dataType()).add("AllowedValues", (Object)this.allowedValues()).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;
        private String description;
        private String dataType;
        private String allowedValues;
        private String minimumEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.name(model.name);
            this.value(model.value);
            this.description(model.description);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.minimumEngineVersion(model.minimumEngineVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameter> {
        public Builder name(String var1);

        public Builder value(String var1);

        public Builder description(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder minimumEngineVersion(String var1);
    }
}

