/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.EngineVersionInfo;

public class DescribeEngineVersionsIterable
implements SdkIterable<DescribeEngineVersionsResponse> {
    private final MemoryDbClient client;
    private final DescribeEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEngineVersionsIterable(MemoryDbClient client, DescribeEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EngineVersionInfo> engineVersions() {
        Function<DescribeEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineVersions() != null) {
                return response.engineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeEngineVersionsResponse> {
        private DescribeEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEngineVersionsResponse nextPage(DescribeEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineVersionsIterable.this.client.describeEngineVersions(DescribeEngineVersionsIterable.this.firstRequest);
            }
            return DescribeEngineVersionsIterable.this.client.describeEngineVersions((DescribeEngineVersionsRequest)((Object)DescribeEngineVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

