/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AacAudioDescriptionBroadcasterMix;
import software.amazon.awssdk.services.mediaconvert.model.AacCodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.AacCodingMode;
import software.amazon.awssdk.services.mediaconvert.model.AacRateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.AacRawFormat;
import software.amazon.awssdk.services.mediaconvert.model.AacSpecification;
import software.amazon.awssdk.services.mediaconvert.model.AacVbrQuality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AacSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AacSettings> {
    private static final SdkField<String> AUDIO_DESCRIPTION_BROADCASTER_MIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::audioDescriptionBroadcasterMixAsString)).setter(AacSettings.setter(Builder::audioDescriptionBroadcasterMix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptionBroadcasterMix").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AacSettings.getter(AacSettings::bitrate)).setter(AacSettings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::codecProfileAsString)).setter(AacSettings.setter(Builder::codecProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::codingModeAsString)).setter(AacSettings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::rateControlModeAsString)).setter(AacSettings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> RAW_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::rawFormatAsString)).setter(AacSettings.setter(Builder::rawFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawFormat").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AacSettings.getter(AacSettings::sampleRate)).setter(AacSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<String> SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::specificationAsString)).setter(AacSettings.setter(Builder::specification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specification").build()}).build();
    private static final SdkField<String> VBR_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AacSettings.getter(AacSettings::vbrQualityAsString)).setter(AacSettings.setter(Builder::vbrQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTION_BROADCASTER_MIX_FIELD, BITRATE_FIELD, CODEC_PROFILE_FIELD, CODING_MODE_FIELD, RATE_CONTROL_MODE_FIELD, RAW_FORMAT_FIELD, SAMPLE_RATE_FIELD, SPECIFICATION_FIELD, VBR_QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioDescriptionBroadcasterMix;
    private final Integer bitrate;
    private final String codecProfile;
    private final String codingMode;
    private final String rateControlMode;
    private final String rawFormat;
    private final Integer sampleRate;
    private final String specification;
    private final String vbrQuality;

    private AacSettings(BuilderImpl builder) {
        this.audioDescriptionBroadcasterMix = builder.audioDescriptionBroadcasterMix;
        this.bitrate = builder.bitrate;
        this.codecProfile = builder.codecProfile;
        this.codingMode = builder.codingMode;
        this.rateControlMode = builder.rateControlMode;
        this.rawFormat = builder.rawFormat;
        this.sampleRate = builder.sampleRate;
        this.specification = builder.specification;
        this.vbrQuality = builder.vbrQuality;
    }

    public AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix() {
        return AacAudioDescriptionBroadcasterMix.fromValue(this.audioDescriptionBroadcasterMix);
    }

    public String audioDescriptionBroadcasterMixAsString() {
        return this.audioDescriptionBroadcasterMix;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public AacCodecProfile codecProfile() {
        return AacCodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileAsString() {
        return this.codecProfile;
    }

    public AacCodingMode codingMode() {
        return AacCodingMode.fromValue(this.codingMode);
    }

    public String codingModeAsString() {
        return this.codingMode;
    }

    public AacRateControlMode rateControlMode() {
        return AacRateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public AacRawFormat rawFormat() {
        return AacRawFormat.fromValue(this.rawFormat);
    }

    public String rawFormatAsString() {
        return this.rawFormat;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public AacSpecification specification() {
        return AacSpecification.fromValue(this.specification);
    }

    public String specificationAsString() {
        return this.specification;
    }

    public AacVbrQuality vbrQuality() {
        return AacVbrQuality.fromValue(this.vbrQuality);
    }

    public String vbrQualityAsString() {
        return this.vbrQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptionBroadcasterMixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.specificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vbrQualityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AacSettings)) {
            return false;
        }
        AacSettings other = (AacSettings)obj;
        return Objects.equals(this.audioDescriptionBroadcasterMixAsString(), other.audioDescriptionBroadcasterMixAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.rawFormatAsString(), other.rawFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.specificationAsString(), other.specificationAsString()) && Objects.equals(this.vbrQualityAsString(), other.vbrQualityAsString());
    }

    public String toString() {
        return ToString.builder((String)"AacSettings").add("AudioDescriptionBroadcasterMix", (Object)this.audioDescriptionBroadcasterMixAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecProfile", (Object)this.codecProfileAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("RawFormat", (Object)this.rawFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("Specification", (Object)this.specificationAsString()).add("VbrQuality", (Object)this.vbrQualityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptionBroadcasterMix": {
                return Optional.ofNullable(clazz.cast(this.audioDescriptionBroadcasterMixAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "RawFormat": {
                return Optional.ofNullable(clazz.cast(this.rawFormatAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "Specification": {
                return Optional.ofNullable(clazz.cast(this.specificationAsString()));
            }
            case "VbrQuality": {
                return Optional.ofNullable(clazz.cast(this.vbrQualityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AacSettings, T> g) {
        return obj -> g.apply((AacSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDescriptionBroadcasterMix;
        private Integer bitrate;
        private String codecProfile;
        private String codingMode;
        private String rateControlMode;
        private String rawFormat;
        private Integer sampleRate;
        private String specification;
        private String vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(AacSettings model) {
            this.audioDescriptionBroadcasterMix(model.audioDescriptionBroadcasterMix);
            this.bitrate(model.bitrate);
            this.codecProfile(model.codecProfile);
            this.codingMode(model.codingMode);
            this.rateControlMode(model.rateControlMode);
            this.rawFormat(model.rawFormat);
            this.sampleRate(model.sampleRate);
            this.specification(model.specification);
            this.vbrQuality(model.vbrQuality);
        }

        public final String getAudioDescriptionBroadcasterMixAsString() {
            return this.audioDescriptionBroadcasterMix;
        }

        @Override
        public final Builder audioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix = audioDescriptionBroadcasterMix;
            return this;
        }

        @Override
        public final Builder audioDescriptionBroadcasterMix(AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix(audioDescriptionBroadcasterMix.toString());
            return this;
        }

        public final void setAudioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix = audioDescriptionBroadcasterMix;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecProfileAsString() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(AacCodecProfile codecProfile) {
            this.codecProfile(codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getCodingModeAsString() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(AacCodingMode codingMode) {
            this.codingMode(codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final String getRateControlModeAsString() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(AacRateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRawFormatAsString() {
            return this.rawFormat;
        }

        @Override
        public final Builder rawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
            return this;
        }

        @Override
        public final Builder rawFormat(AacRawFormat rawFormat) {
            this.rawFormat(rawFormat.toString());
            return this;
        }

        public final void setRawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getSpecificationAsString() {
            return this.specification;
        }

        @Override
        public final Builder specification(String specification) {
            this.specification = specification;
            return this;
        }

        @Override
        public final Builder specification(AacSpecification specification) {
            this.specification(specification.toString());
            return this;
        }

        public final void setSpecification(String specification) {
            this.specification = specification;
        }

        public final String getVbrQualityAsString() {
            return this.vbrQuality;
        }

        @Override
        public final Builder vbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        public final Builder vbrQuality(AacVbrQuality vbrQuality) {
            this.vbrQuality(vbrQuality.toString());
            return this;
        }

        public final void setVbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        public AacSettings build() {
            return new AacSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AacSettings> {
        public Builder audioDescriptionBroadcasterMix(String var1);

        public Builder audioDescriptionBroadcasterMix(AacAudioDescriptionBroadcasterMix var1);

        public Builder bitrate(Integer var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(AacCodecProfile var1);

        public Builder codingMode(String var1);

        public Builder codingMode(AacCodingMode var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(AacRateControlMode var1);

        public Builder rawFormat(String var1);

        public Builder rawFormat(AacRawFormat var1);

        public Builder sampleRate(Integer var1);

        public Builder specification(String var1);

        public Builder specification(AacSpecification var1);

        public Builder vbrQuality(String var1);

        public Builder vbrQuality(AacVbrQuality var1);
    }
}

