/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.OutputSdt;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DvbSdtSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DvbSdtSettings> {
    private static final SdkField<String> OUTPUT_SDT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DvbSdtSettings.getter(DvbSdtSettings::outputSdtAsString)).setter(DvbSdtSettings.setter(Builder::outputSdt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSdt").build()}).build();
    private static final SdkField<Integer> SDT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DvbSdtSettings.getter(DvbSdtSettings::sdtInterval)).setter(DvbSdtSettings.setter(Builder::sdtInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdtInterval").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DvbSdtSettings.getter(DvbSdtSettings::serviceName)).setter(DvbSdtSettings.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DvbSdtSettings.getter(DvbSdtSettings::serviceProviderName)).setter(DvbSdtSettings.setter(Builder::serviceProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceProviderName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SDT_FIELD, SDT_INTERVAL_FIELD, SERVICE_NAME_FIELD, SERVICE_PROVIDER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputSdt;
    private final Integer sdtInterval;
    private final String serviceName;
    private final String serviceProviderName;

    private DvbSdtSettings(BuilderImpl builder) {
        this.outputSdt = builder.outputSdt;
        this.sdtInterval = builder.sdtInterval;
        this.serviceName = builder.serviceName;
        this.serviceProviderName = builder.serviceProviderName;
    }

    public OutputSdt outputSdt() {
        return OutputSdt.fromValue(this.outputSdt);
    }

    public String outputSdtAsString() {
        return this.outputSdt;
    }

    public Integer sdtInterval() {
        return this.sdtInterval;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceProviderName() {
        return this.serviceProviderName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSdtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProviderName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSdtSettings)) {
            return false;
        }
        DvbSdtSettings other = (DvbSdtSettings)obj;
        return Objects.equals(this.outputSdtAsString(), other.outputSdtAsString()) && Objects.equals(this.sdtInterval(), other.sdtInterval()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceProviderName(), other.serviceProviderName());
    }

    public String toString() {
        return ToString.builder((String)"DvbSdtSettings").add("OutputSdt", (Object)this.outputSdtAsString()).add("SdtInterval", (Object)this.sdtInterval()).add("ServiceName", (Object)this.serviceName()).add("ServiceProviderName", (Object)this.serviceProviderName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputSdt": {
                return Optional.ofNullable(clazz.cast(this.outputSdtAsString()));
            }
            case "SdtInterval": {
                return Optional.ofNullable(clazz.cast(this.sdtInterval()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceProviderName": {
                return Optional.ofNullable(clazz.cast(this.serviceProviderName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbSdtSettings, T> g) {
        return obj -> g.apply((DvbSdtSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputSdt;
        private Integer sdtInterval;
        private String serviceName;
        private String serviceProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSdtSettings model) {
            this.outputSdt(model.outputSdt);
            this.sdtInterval(model.sdtInterval);
            this.serviceName(model.serviceName);
            this.serviceProviderName(model.serviceProviderName);
        }

        public final String getOutputSdtAsString() {
            return this.outputSdt;
        }

        @Override
        public final Builder outputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
            return this;
        }

        @Override
        public final Builder outputSdt(OutputSdt outputSdt) {
            this.outputSdt(outputSdt == null ? null : outputSdt.toString());
            return this;
        }

        public final void setOutputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
        }

        public final Integer getSdtInterval() {
            return this.sdtInterval;
        }

        @Override
        public final Builder sdtInterval(Integer sdtInterval) {
            this.sdtInterval = sdtInterval;
            return this;
        }

        public final void setSdtInterval(Integer sdtInterval) {
            this.sdtInterval = sdtInterval;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceProviderName() {
            return this.serviceProviderName;
        }

        @Override
        public final Builder serviceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
            return this;
        }

        public final void setServiceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
        }

        public DvbSdtSettings build() {
            return new DvbSdtSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DvbSdtSettings> {
        public Builder outputSdt(String var1);

        public Builder outputSdt(OutputSdt var1);

        public Builder sdtInterval(Integer var1);

        public Builder serviceName(String var1);

        public Builder serviceProviderName(String var1);
    }
}

