/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CaptionDestinationType {
    BURN_IN("BURN_IN"),
    DVB_SUB("DVB_SUB"),
    EMBEDDED("EMBEDDED"),
    EMBEDDED_PLUS_SCTE20("EMBEDDED_PLUS_SCTE20"),
    SCTE20_PLUS_EMBEDDED("SCTE20_PLUS_EMBEDDED"),
    SCC("SCC"),
    SRT("SRT"),
    SMI("SMI"),
    TELETEXT("TELETEXT"),
    TTML("TTML"),
    WEBVTT("WEBVTT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CaptionDestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaptionDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CaptionDestinationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CaptionDestinationType> knownValues() {
        return Stream.of(CaptionDestinationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

