/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HlsCodecSpecification {
    RFC_6381("RFC_6381"),
    RFC_4281("RFC_4281"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HlsCodecSpecification(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsCodecSpecification fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HlsCodecSpecification.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsCodecSpecification> knownValues() {
        return Stream.of(HlsCodecSpecification.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

