/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleAlignment;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleBackgroundColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleFontColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleOutlineColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleShadowColor;
import software.amazon.awssdk.services.mediaconvert.model.BurninSubtitleTeletextSpacing;
import software.amazon.awssdk.services.mediaconvert.model.FontScript;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BurninDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BurninDestinationSettings> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::alignmentAsString)).setter(BurninDestinationSettings.setter(Builder::alignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()}).build();
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::backgroundColorAsString)).setter(BurninDestinationSettings.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundColor").build()}).build();
    private static final SdkField<Integer> BACKGROUND_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::backgroundOpacity)).setter(BurninDestinationSettings.setter(Builder::backgroundOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundOpacity").build()}).build();
    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontColorAsString)).setter(BurninDestinationSettings.setter(Builder::fontColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontColor").build()}).build();
    private static final SdkField<Integer> FONT_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontOpacity)).setter(BurninDestinationSettings.setter(Builder::fontOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontOpacity").build()}).build();
    private static final SdkField<Integer> FONT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontResolution)).setter(BurninDestinationSettings.setter(Builder::fontResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontResolution").build()}).build();
    private static final SdkField<String> FONT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontScriptAsString)).setter(BurninDestinationSettings.setter(Builder::fontScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontScript").build()}).build();
    private static final SdkField<Integer> FONT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::fontSize)).setter(BurninDestinationSettings.setter(Builder::fontSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()}).build();
    private static final SdkField<String> OUTLINE_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::outlineColorAsString)).setter(BurninDestinationSettings.setter(Builder::outlineColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineColor").build()}).build();
    private static final SdkField<Integer> OUTLINE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::outlineSize)).setter(BurninDestinationSettings.setter(Builder::outlineSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineSize").build()}).build();
    private static final SdkField<String> SHADOW_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowColorAsString)).setter(BurninDestinationSettings.setter(Builder::shadowColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowColor").build()}).build();
    private static final SdkField<Integer> SHADOW_OPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowOpacity)).setter(BurninDestinationSettings.setter(Builder::shadowOpacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowOpacity").build()}).build();
    private static final SdkField<Integer> SHADOW_X_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowXOffset)).setter(BurninDestinationSettings.setter(Builder::shadowXOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowXOffset").build()}).build();
    private static final SdkField<Integer> SHADOW_Y_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::shadowYOffset)).setter(BurninDestinationSettings.setter(Builder::shadowYOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowYOffset").build()}).build();
    private static final SdkField<String> TELETEXT_SPACING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BurninDestinationSettings.getter(BurninDestinationSettings::teletextSpacingAsString)).setter(BurninDestinationSettings.setter(Builder::teletextSpacing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSpacing").build()}).build();
    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::xPosition)).setter(BurninDestinationSettings.setter(Builder::xPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()}).build();
    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BurninDestinationSettings.getter(BurninDestinationSettings::yPosition)).setter(BurninDestinationSettings.setter(Builder::yPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD, BACKGROUND_COLOR_FIELD, BACKGROUND_OPACITY_FIELD, FONT_COLOR_FIELD, FONT_OPACITY_FIELD, FONT_RESOLUTION_FIELD, FONT_SCRIPT_FIELD, FONT_SIZE_FIELD, OUTLINE_COLOR_FIELD, OUTLINE_SIZE_FIELD, SHADOW_COLOR_FIELD, SHADOW_OPACITY_FIELD, SHADOW_X_OFFSET_FIELD, SHADOW_Y_OFFSET_FIELD, TELETEXT_SPACING_FIELD, X_POSITION_FIELD, Y_POSITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alignment;
    private final String backgroundColor;
    private final Integer backgroundOpacity;
    private final String fontColor;
    private final Integer fontOpacity;
    private final Integer fontResolution;
    private final String fontScript;
    private final Integer fontSize;
    private final String outlineColor;
    private final Integer outlineSize;
    private final String shadowColor;
    private final Integer shadowOpacity;
    private final Integer shadowXOffset;
    private final Integer shadowYOffset;
    private final String teletextSpacing;
    private final Integer xPosition;
    private final Integer yPosition;

    private BurninDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.fontColor = builder.fontColor;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontScript = builder.fontScript;
        this.fontSize = builder.fontSize;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.teletextSpacing = builder.teletextSpacing;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    public BurninSubtitleAlignment alignment() {
        return BurninSubtitleAlignment.fromValue(this.alignment);
    }

    public String alignmentAsString() {
        return this.alignment;
    }

    public BurninSubtitleBackgroundColor backgroundColor() {
        return BurninSubtitleBackgroundColor.fromValue(this.backgroundColor);
    }

    public String backgroundColorAsString() {
        return this.backgroundColor;
    }

    public Integer backgroundOpacity() {
        return this.backgroundOpacity;
    }

    public BurninSubtitleFontColor fontColor() {
        return BurninSubtitleFontColor.fromValue(this.fontColor);
    }

    public String fontColorAsString() {
        return this.fontColor;
    }

    public Integer fontOpacity() {
        return this.fontOpacity;
    }

    public Integer fontResolution() {
        return this.fontResolution;
    }

    public FontScript fontScript() {
        return FontScript.fromValue(this.fontScript);
    }

    public String fontScriptAsString() {
        return this.fontScript;
    }

    public Integer fontSize() {
        return this.fontSize;
    }

    public BurninSubtitleOutlineColor outlineColor() {
        return BurninSubtitleOutlineColor.fromValue(this.outlineColor);
    }

    public String outlineColorAsString() {
        return this.outlineColor;
    }

    public Integer outlineSize() {
        return this.outlineSize;
    }

    public BurninSubtitleShadowColor shadowColor() {
        return BurninSubtitleShadowColor.fromValue(this.shadowColor);
    }

    public String shadowColorAsString() {
        return this.shadowColor;
    }

    public Integer shadowOpacity() {
        return this.shadowOpacity;
    }

    public Integer shadowXOffset() {
        return this.shadowXOffset;
    }

    public Integer shadowYOffset() {
        return this.shadowYOffset;
    }

    public BurninSubtitleTeletextSpacing teletextSpacing() {
        return BurninSubtitleTeletextSpacing.fromValue(this.teletextSpacing);
    }

    public String teletextSpacingAsString() {
        return this.teletextSpacing;
    }

    public Integer xPosition() {
        return this.xPosition;
    }

    public Integer yPosition() {
        return this.yPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontScriptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextSpacingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.yPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BurninDestinationSettings)) {
            return false;
        }
        BurninDestinationSettings other = (BurninDestinationSettings)obj;
        return Objects.equals(this.alignmentAsString(), other.alignmentAsString()) && Objects.equals(this.backgroundColorAsString(), other.backgroundColorAsString()) && Objects.equals(this.backgroundOpacity(), other.backgroundOpacity()) && Objects.equals(this.fontColorAsString(), other.fontColorAsString()) && Objects.equals(this.fontOpacity(), other.fontOpacity()) && Objects.equals(this.fontResolution(), other.fontResolution()) && Objects.equals(this.fontScriptAsString(), other.fontScriptAsString()) && Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.outlineColorAsString(), other.outlineColorAsString()) && Objects.equals(this.outlineSize(), other.outlineSize()) && Objects.equals(this.shadowColorAsString(), other.shadowColorAsString()) && Objects.equals(this.shadowOpacity(), other.shadowOpacity()) && Objects.equals(this.shadowXOffset(), other.shadowXOffset()) && Objects.equals(this.shadowYOffset(), other.shadowYOffset()) && Objects.equals(this.teletextSpacingAsString(), other.teletextSpacingAsString()) && Objects.equals(this.xPosition(), other.xPosition()) && Objects.equals(this.yPosition(), other.yPosition());
    }

    public String toString() {
        return ToString.builder((String)"BurninDestinationSettings").add("Alignment", (Object)this.alignmentAsString()).add("BackgroundColor", (Object)this.backgroundColorAsString()).add("BackgroundOpacity", (Object)this.backgroundOpacity()).add("FontColor", (Object)this.fontColorAsString()).add("FontOpacity", (Object)this.fontOpacity()).add("FontResolution", (Object)this.fontResolution()).add("FontScript", (Object)this.fontScriptAsString()).add("FontSize", (Object)this.fontSize()).add("OutlineColor", (Object)this.outlineColorAsString()).add("OutlineSize", (Object)this.outlineSize()).add("ShadowColor", (Object)this.shadowColorAsString()).add("ShadowOpacity", (Object)this.shadowOpacity()).add("ShadowXOffset", (Object)this.shadowXOffset()).add("ShadowYOffset", (Object)this.shadowYOffset()).add("TeletextSpacing", (Object)this.teletextSpacingAsString()).add("XPosition", (Object)this.xPosition()).add("YPosition", (Object)this.yPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.ofNullable(clazz.cast(this.alignmentAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColorAsString()));
            }
            case "BackgroundOpacity": {
                return Optional.ofNullable(clazz.cast(this.backgroundOpacity()));
            }
            case "FontColor": {
                return Optional.ofNullable(clazz.cast(this.fontColorAsString()));
            }
            case "FontOpacity": {
                return Optional.ofNullable(clazz.cast(this.fontOpacity()));
            }
            case "FontResolution": {
                return Optional.ofNullable(clazz.cast(this.fontResolution()));
            }
            case "FontScript": {
                return Optional.ofNullable(clazz.cast(this.fontScriptAsString()));
            }
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSize()));
            }
            case "OutlineColor": {
                return Optional.ofNullable(clazz.cast(this.outlineColorAsString()));
            }
            case "OutlineSize": {
                return Optional.ofNullable(clazz.cast(this.outlineSize()));
            }
            case "ShadowColor": {
                return Optional.ofNullable(clazz.cast(this.shadowColorAsString()));
            }
            case "ShadowOpacity": {
                return Optional.ofNullable(clazz.cast(this.shadowOpacity()));
            }
            case "ShadowXOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowXOffset()));
            }
            case "ShadowYOffset": {
                return Optional.ofNullable(clazz.cast(this.shadowYOffset()));
            }
            case "TeletextSpacing": {
                return Optional.ofNullable(clazz.cast(this.teletextSpacingAsString()));
            }
            case "XPosition": {
                return Optional.ofNullable(clazz.cast(this.xPosition()));
            }
            case "YPosition": {
                return Optional.ofNullable(clazz.cast(this.yPosition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BurninDestinationSettings, T> g) {
        return obj -> g.apply((BurninDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String backgroundColor;
        private Integer backgroundOpacity;
        private String fontColor;
        private Integer fontOpacity;
        private Integer fontResolution;
        private String fontScript;
        private Integer fontSize;
        private String outlineColor;
        private Integer outlineSize;
        private String shadowColor;
        private Integer shadowOpacity;
        private Integer shadowXOffset;
        private Integer shadowYOffset;
        private String teletextSpacing;
        private Integer xPosition;
        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(BurninDestinationSettings model) {
            this.alignment(model.alignment);
            this.backgroundColor(model.backgroundColor);
            this.backgroundOpacity(model.backgroundOpacity);
            this.fontColor(model.fontColor);
            this.fontOpacity(model.fontOpacity);
            this.fontResolution(model.fontResolution);
            this.fontScript(model.fontScript);
            this.fontSize(model.fontSize);
            this.outlineColor(model.outlineColor);
            this.outlineSize(model.outlineSize);
            this.shadowColor(model.shadowColor);
            this.shadowOpacity(model.shadowOpacity);
            this.shadowXOffset(model.shadowXOffset);
            this.shadowYOffset(model.shadowYOffset);
            this.teletextSpacing(model.teletextSpacing);
            this.xPosition(model.xPosition);
            this.yPosition(model.yPosition);
        }

        public final String getAlignmentAsString() {
            return this.alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(BurninSubtitleAlignment alignment) {
            this.alignment(alignment.toString());
            return this;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public final String getBackgroundColorAsString() {
            return this.backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(BurninSubtitleBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor.toString());
            return this;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public final Integer getBackgroundOpacity() {
            return this.backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        public final String getFontColorAsString() {
            return this.fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(BurninSubtitleFontColor fontColor) {
            this.fontColor(fontColor.toString());
            return this;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public final Integer getFontOpacity() {
            return this.fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        public final Integer getFontResolution() {
            return this.fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        public final String getFontScriptAsString() {
            return this.fontScript;
        }

        @Override
        public final Builder fontScript(String fontScript) {
            this.fontScript = fontScript;
            return this;
        }

        @Override
        public final Builder fontScript(FontScript fontScript) {
            this.fontScript(fontScript.toString());
            return this;
        }

        public final void setFontScript(String fontScript) {
            this.fontScript = fontScript;
        }

        public final Integer getFontSize() {
            return this.fontSize;
        }

        @Override
        public final Builder fontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(Integer fontSize) {
            this.fontSize = fontSize;
        }

        public final String getOutlineColorAsString() {
            return this.outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(BurninSubtitleOutlineColor outlineColor) {
            this.outlineColor(outlineColor.toString());
            return this;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        public final Integer getOutlineSize() {
            return this.outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        public final String getShadowColorAsString() {
            return this.shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(BurninSubtitleShadowColor shadowColor) {
            this.shadowColor(shadowColor.toString());
            return this;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        public final Integer getShadowOpacity() {
            return this.shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        public final Integer getShadowXOffset() {
            return this.shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        public final Integer getShadowYOffset() {
            return this.shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        public final String getTeletextSpacingAsString() {
            return this.teletextSpacing;
        }

        @Override
        public final Builder teletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
            return this;
        }

        @Override
        public final Builder teletextSpacing(BurninSubtitleTeletextSpacing teletextSpacing) {
            this.teletextSpacing(teletextSpacing.toString());
            return this;
        }

        public final void setTeletextSpacing(String teletextSpacing) {
            this.teletextSpacing = teletextSpacing;
        }

        public final Integer getXPosition() {
            return this.xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        public final Integer getYPosition() {
            return this.yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        public BurninDestinationSettings build() {
            return new BurninDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BurninDestinationSettings> {
        public Builder alignment(String var1);

        public Builder alignment(BurninSubtitleAlignment var1);

        public Builder backgroundColor(String var1);

        public Builder backgroundColor(BurninSubtitleBackgroundColor var1);

        public Builder backgroundOpacity(Integer var1);

        public Builder fontColor(String var1);

        public Builder fontColor(BurninSubtitleFontColor var1);

        public Builder fontOpacity(Integer var1);

        public Builder fontResolution(Integer var1);

        public Builder fontScript(String var1);

        public Builder fontScript(FontScript var1);

        public Builder fontSize(Integer var1);

        public Builder outlineColor(String var1);

        public Builder outlineColor(BurninSubtitleOutlineColor var1);

        public Builder outlineSize(Integer var1);

        public Builder shadowColor(String var1);

        public Builder shadowColor(BurninSubtitleShadowColor var1);

        public Builder shadowOpacity(Integer var1);

        public Builder shadowXOffset(Integer var1);

        public Builder shadowYOffset(Integer var1);

        public Builder teletextSpacing(String var1);

        public Builder teletextSpacing(BurninSubtitleTeletextSpacing var1);

        public Builder xPosition(Integer var1);

        public Builder yPosition(Integer var1);
    }
}

