/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.HlsAdMarkers;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageSetting;
import software.amazon.awssdk.services.mediaconvert.model.HlsClientCache;
import software.amazon.awssdk.services.mediaconvert.model.HlsCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.HlsDirectoryStructure;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.HlsManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.HlsOutputSelection;
import software.amazon.awssdk.services.mediaconvert.model.HlsProgramDateTime;
import software.amazon.awssdk.services.mediaconvert.model.HlsSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.HlsStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.HlsTimedMetadataId3Frame;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHlsAdMarkersCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfHlsCaptionLanguageMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HlsGroupSettings.getter(HlsGroupSettings::adMarkersAsStrings)).setter(HlsGroupSettings.setter(Builder::adMarkersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::baseUrl)).setter(HlsGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<List<HlsCaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HlsGroupSettings.getter(HlsGroupSettings::captionLanguageMappings)).setter(HlsGroupSettings.setter(Builder::captionLanguageMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsCaptionLanguageMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CAPTION_LANGUAGE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::captionLanguageSettingAsString)).setter(HlsGroupSettings.setter(Builder::captionLanguageSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageSetting").build()}).build();
    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::clientCacheAsString)).setter(HlsGroupSettings.setter(Builder::clientCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()}).build();
    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::codecSpecificationAsString)).setter(HlsGroupSettings.setter(Builder::codecSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::destination)).setter(HlsGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> DIRECTORY_STRUCTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::directoryStructureAsString)).setter(HlsGroupSettings.setter(Builder::directoryStructure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryStructure").build()}).build();
    private static final SdkField<HlsEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HlsGroupSettings.getter(HlsGroupSettings::encryption)).setter(HlsGroupSettings.setter(Builder::encryption)).constructor(HlsEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::manifestCompressionAsString)).setter(HlsGroupSettings.setter(Builder::manifestCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build()}).build();
    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::manifestDurationFormatAsString)).setter(HlsGroupSettings.setter(Builder::manifestDurationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build()}).build();
    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(HlsGroupSettings.getter(HlsGroupSettings::minFinalSegmentLength)).setter(HlsGroupSettings.setter(Builder::minFinalSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build()}).build();
    private static final SdkField<Integer> MIN_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsGroupSettings.getter(HlsGroupSettings::minSegmentLength)).setter(HlsGroupSettings.setter(Builder::minSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSegmentLength").build()}).build();
    private static final SdkField<String> OUTPUT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::outputSelectionAsString)).setter(HlsGroupSettings.setter(Builder::outputSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSelection").build()}).build();
    private static final SdkField<String> PROGRAM_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::programDateTimeAsString)).setter(HlsGroupSettings.setter(Builder::programDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTime").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsGroupSettings.getter(HlsGroupSettings::programDateTimePeriod)).setter(HlsGroupSettings.setter(Builder::programDateTimePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimePeriod").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::segmentControlAsString)).setter(HlsGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsGroupSettings.getter(HlsGroupSettings::segmentLength)).setter(HlsGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<Integer> SEGMENTS_PER_SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsGroupSettings.getter(HlsGroupSettings::segmentsPerSubdirectory)).setter(HlsGroupSettings.setter(Builder::segmentsPerSubdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsPerSubdirectory").build()}).build();
    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::streamInfResolutionAsString)).setter(HlsGroupSettings.setter(Builder::streamInfResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build()}).build();
    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsGroupSettings.getter(HlsGroupSettings::timedMetadataId3FrameAsString)).setter(HlsGroupSettings.setter(Builder::timedMetadataId3Frame)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build()}).build();
    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsGroupSettings.getter(HlsGroupSettings::timedMetadataId3Period)).setter(HlsGroupSettings.setter(Builder::timedMetadataId3Period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build()}).build();
    private static final SdkField<Integer> TIMESTAMP_DELTA_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsGroupSettings.getter(HlsGroupSettings::timestampDeltaMilliseconds)).setter(HlsGroupSettings.setter(Builder::timestampDeltaMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampDeltaMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, BASE_URL_FIELD, CAPTION_LANGUAGE_MAPPINGS_FIELD, CAPTION_LANGUAGE_SETTING_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DESTINATION_FIELD, DIRECTORY_STRUCTURE_FIELD, ENCRYPTION_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MIN_SEGMENT_LENGTH_FIELD, OUTPUT_SELECTION_FIELD, PROGRAM_DATE_TIME_FIELD, PROGRAM_DATE_TIME_PERIOD_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, SEGMENTS_PER_SUBDIRECTORY_FIELD, STREAM_INF_RESOLUTION_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD, TIMESTAMP_DELTA_MILLISECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> adMarkers;
    private final String baseUrl;
    private final List<HlsCaptionLanguageMapping> captionLanguageMappings;
    private final String captionLanguageSetting;
    private final String clientCache;
    private final String codecSpecification;
    private final String destination;
    private final String directoryStructure;
    private final HlsEncryptionSettings encryption;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Double minFinalSegmentLength;
    private final Integer minSegmentLength;
    private final String outputSelection;
    private final String programDateTime;
    private final Integer programDateTimePeriod;
    private final String segmentControl;
    private final Integer segmentLength;
    private final Integer segmentsPerSubdirectory;
    private final String streamInfResolution;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;
    private final Integer timestampDeltaMilliseconds;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.baseUrl = builder.baseUrl;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.directoryStructure = builder.directoryStructure;
        this.encryption = builder.encryption;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.minSegmentLength = builder.minSegmentLength;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
    }

    public List<HlsAdMarkers> adMarkers() {
        return ___listOfHlsAdMarkersCopier.copyStringToEnum(this.adMarkers);
    }

    public List<String> adMarkersAsStrings() {
        return this.adMarkers;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public List<HlsCaptionLanguageMapping> captionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(this.captionLanguageSetting);
    }

    public String captionLanguageSettingAsString() {
        return this.captionLanguageSetting;
    }

    public HlsClientCache clientCache() {
        return HlsClientCache.fromValue(this.clientCache);
    }

    public String clientCacheAsString() {
        return this.clientCache;
    }

    public HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(this.codecSpecification);
    }

    public String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public String destination() {
        return this.destination;
    }

    public HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(this.directoryStructure);
    }

    public String directoryStructureAsString() {
        return this.directoryStructure;
    }

    public HlsEncryptionSettings encryption() {
        return this.encryption;
    }

    public HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(this.manifestCompression);
    }

    public String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public Integer minSegmentLength() {
        return this.minSegmentLength;
    }

    public HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(this.outputSelection);
    }

    public String outputSelectionAsString() {
        return this.outputSelection;
    }

    public HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(this.programDateTime);
    }

    public String programDateTimeAsString() {
        return this.programDateTime;
    }

    public Integer programDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public HlsSegmentControl segmentControl() {
        return HlsSegmentControl.fromValue(this.segmentControl);
    }

    public String segmentControlAsString() {
        return this.segmentControl;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public Integer segmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public String timedMetadataId3FrameAsString() {
        return this.timedMetadataId3Frame;
    }

    public Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public Integer timestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryStructureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampDeltaMilliseconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        return Objects.equals(this.adMarkersAsStrings(), other.adMarkersAsStrings()) && Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.captionLanguageMappings(), other.captionLanguageMappings()) && Objects.equals(this.captionLanguageSettingAsString(), other.captionLanguageSettingAsString()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.directoryStructureAsString(), other.directoryStructureAsString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.minSegmentLength(), other.minSegmentLength()) && Objects.equals(this.outputSelectionAsString(), other.outputSelectionAsString()) && Objects.equals(this.programDateTimeAsString(), other.programDateTimeAsString()) && Objects.equals(this.programDateTimePeriod(), other.programDateTimePeriod()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentsPerSubdirectory(), other.segmentsPerSubdirectory()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period()) && Objects.equals(this.timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds());
    }

    public String toString() {
        return ToString.builder((String)"HlsGroupSettings").add("AdMarkers", this.adMarkersAsStrings()).add("BaseUrl", (Object)this.baseUrl()).add("CaptionLanguageMappings", this.captionLanguageMappings()).add("CaptionLanguageSetting", (Object)this.captionLanguageSettingAsString()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("Destination", (Object)this.destination()).add("DirectoryStructure", (Object)this.directoryStructureAsString()).add("Encryption", (Object)this.encryption()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("MinSegmentLength", (Object)this.minSegmentLength()).add("OutputSelection", (Object)this.outputSelectionAsString()).add("ProgramDateTime", (Object)this.programDateTimeAsString()).add("ProgramDateTimePeriod", (Object)this.programDateTimePeriod()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentsPerSubdirectory", (Object)this.segmentsPerSubdirectory()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameAsString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).add("TimestampDeltaMilliseconds", (Object)this.timestampDeltaMilliseconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsStrings()));
            }
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "CaptionLanguageMappings": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageMappings()));
            }
            case "CaptionLanguageSetting": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageSettingAsString()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DirectoryStructure": {
                return Optional.ofNullable(clazz.cast(this.directoryStructureAsString()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "MinSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minSegmentLength()));
            }
            case "OutputSelection": {
                return Optional.ofNullable(clazz.cast(this.outputSelectionAsString()));
            }
            case "ProgramDateTime": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeAsString()));
            }
            case "ProgramDateTimePeriod": {
                return Optional.ofNullable(clazz.cast(this.programDateTimePeriod()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentsPerSubdirectory": {
                return Optional.ofNullable(clazz.cast(this.segmentsPerSubdirectory()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3FrameAsString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3Period()));
            }
            case "TimestampDeltaMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.timestampDeltaMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsGroupSettings, T> g) {
        return obj -> g.apply((HlsGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();
        private String baseUrl;
        private List<HlsCaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();
        private String captionLanguageSetting;
        private String clientCache;
        private String codecSpecification;
        private String destination;
        private String directoryStructure;
        private HlsEncryptionSettings encryption;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Double minFinalSegmentLength;
        private Integer minSegmentLength;
        private String outputSelection;
        private String programDateTime;
        private Integer programDateTimePeriod;
        private String segmentControl;
        private Integer segmentLength;
        private Integer segmentsPerSubdirectory;
        private String streamInfResolution;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;
        private Integer timestampDeltaMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            this.adMarkersWithStrings(model.adMarkers);
            this.baseUrl(model.baseUrl);
            this.captionLanguageMappings(model.captionLanguageMappings);
            this.captionLanguageSetting(model.captionLanguageSetting);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.destination(model.destination);
            this.directoryStructure(model.directoryStructure);
            this.encryption(model.encryption);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.minSegmentLength(model.minSegmentLength);
            this.outputSelection(model.outputSelection);
            this.programDateTime(model.programDateTime);
            this.programDateTimePeriod(model.programDateTimePeriod);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            this.streamInfResolution(model.streamInfResolution);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
            this.timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
        }

        public final Collection<String> getAdMarkersAsStrings() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkersWithStrings(String ... adMarkers) {
            this.adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        public final Builder adMarkers(Collection<HlsAdMarkers> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(HlsAdMarkers ... adMarkers) {
            this.adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final void setAdMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final Collection<HlsCaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            return this.captionLanguageMappings != null ? (Collection)this.captionLanguageMappings.stream().map(HlsCaptionLanguageMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(HlsCaptionLanguageMapping ... captionLanguageMappings) {
            this.captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder> ... captionLanguageMappings) {
            this.captionLanguageMappings(Stream.of(captionLanguageMappings).map(c -> (HlsCaptionLanguageMapping)((HlsCaptionLanguageMapping.Builder)HlsCaptionLanguageMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        public final String getCaptionLanguageSettingAsString() {
            return this.captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting.toString());
            return this;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        public final String getClientCacheAsString() {
            return this.clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecificationAsString() {
            return this.codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDirectoryStructureAsString() {
            return this.directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure.toString());
            return this;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        public final HlsEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getManifestCompressionAsString() {
            return this.manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormatAsString() {
            return this.manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        public final Integer getMinSegmentLength() {
            return this.minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        public final String getOutputSelectionAsString() {
            return this.outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection.toString());
            return this;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        public final String getProgramDateTimeAsString() {
            return this.programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime.toString());
            return this;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        public final Integer getProgramDateTimePeriod() {
            return this.programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        public final String getSegmentControlAsString() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(HlsSegmentControl segmentControl) {
            this.segmentControl(segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return this.segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        public final String getStreamInfResolutionAsString() {
            return this.streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getTimedMetadataId3FrameAsString() {
            return this.timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return this.timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsGroupSettings> {
        public Builder adMarkersWithStrings(Collection<String> var1);

        public Builder adMarkersWithStrings(String ... var1);

        public Builder adMarkers(Collection<HlsAdMarkers> var1);

        public Builder adMarkers(HlsAdMarkers ... var1);

        public Builder baseUrl(String var1);

        public Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> var1);

        public Builder captionLanguageMappings(HlsCaptionLanguageMapping ... var1);

        public Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder> ... var1);

        public Builder captionLanguageSetting(String var1);

        public Builder captionLanguageSetting(HlsCaptionLanguageSetting var1);

        public Builder clientCache(String var1);

        public Builder clientCache(HlsClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(HlsCodecSpecification var1);

        public Builder destination(String var1);

        public Builder directoryStructure(String var1);

        public Builder directoryStructure(HlsDirectoryStructure var1);

        public Builder encryption(HlsEncryptionSettings var1);

        default public Builder encryption(Consumer<HlsEncryptionSettings.Builder> encryption) {
            return this.encryption((HlsEncryptionSettings)((HlsEncryptionSettings.Builder)HlsEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(HlsManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(HlsManifestDurationFormat var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder minSegmentLength(Integer var1);

        public Builder outputSelection(String var1);

        public Builder outputSelection(HlsOutputSelection var1);

        public Builder programDateTime(String var1);

        public Builder programDateTime(HlsProgramDateTime var1);

        public Builder programDateTimePeriod(Integer var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(HlsSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentsPerSubdirectory(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(HlsStreamInfResolution var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);

        public Builder timestampDeltaMilliseconds(Integer var1);
    }
}

