/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Av1Settings;
import software.amazon.awssdk.services.mediaconvert.model.AvcIntraSettings;
import software.amazon.awssdk.services.mediaconvert.model.FrameCaptureSettings;
import software.amazon.awssdk.services.mediaconvert.model.H264Settings;
import software.amazon.awssdk.services.mediaconvert.model.H265Settings;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Settings;
import software.amazon.awssdk.services.mediaconvert.model.ProresSettings;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedSettings;
import software.amazon.awssdk.services.mediaconvert.model.Vc3Settings;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodec;
import software.amazon.awssdk.services.mediaconvert.model.Vp8Settings;
import software.amazon.awssdk.services.mediaconvert.model.Vp9Settings;
import software.amazon.awssdk.services.mediaconvert.model.XavcSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoCodecSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoCodecSettings> {
    private static final SdkField<Av1Settings> AV1_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Av1Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::av1Settings)).setter(VideoCodecSettings.setter(Builder::av1Settings)).constructor(Av1Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("av1Settings").build()}).build();
    private static final SdkField<AvcIntraSettings> AVC_INTRA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvcIntraSettings").getter(VideoCodecSettings.getter(VideoCodecSettings::avcIntraSettings)).setter(VideoCodecSettings.setter(Builder::avcIntraSettings)).constructor(AvcIntraSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("avcIntraSettings").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(VideoCodecSettings.getter(VideoCodecSettings::codecAsString)).setter(VideoCodecSettings.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<FrameCaptureSettings> FRAME_CAPTURE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureSettings").getter(VideoCodecSettings.getter(VideoCodecSettings::frameCaptureSettings)).setter(VideoCodecSettings.setter(Builder::frameCaptureSettings)).constructor(FrameCaptureSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureSettings").build()}).build();
    private static final SdkField<H264Settings> H264_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("H264Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::h264Settings)).setter(VideoCodecSettings.setter(Builder::h264Settings)).constructor(H264Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h264Settings").build()}).build();
    private static final SdkField<H265Settings> H265_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("H265Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::h265Settings)).setter(VideoCodecSettings.setter(Builder::h265Settings)).constructor(H265Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265Settings").build()}).build();
    private static final SdkField<Mpeg2Settings> MPEG2_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mpeg2Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::mpeg2Settings)).setter(VideoCodecSettings.setter(Builder::mpeg2Settings)).constructor(Mpeg2Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2Settings").build()}).build();
    private static final SdkField<ProresSettings> PRORES_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProresSettings").getter(VideoCodecSettings.getter(VideoCodecSettings::proresSettings)).setter(VideoCodecSettings.setter(Builder::proresSettings)).constructor(ProresSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proresSettings").build()}).build();
    private static final SdkField<UncompressedSettings> UNCOMPRESSED_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UncompressedSettings").getter(VideoCodecSettings.getter(VideoCodecSettings::uncompressedSettings)).setter(VideoCodecSettings.setter(Builder::uncompressedSettings)).constructor(UncompressedSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uncompressedSettings").build()}).build();
    private static final SdkField<Vc3Settings> VC3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vc3Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::vc3Settings)).setter(VideoCodecSettings.setter(Builder::vc3Settings)).constructor(Vc3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vc3Settings").build()}).build();
    private static final SdkField<Vp8Settings> VP8_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vp8Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::vp8Settings)).setter(VideoCodecSettings.setter(Builder::vp8Settings)).constructor(Vp8Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vp8Settings").build()}).build();
    private static final SdkField<Vp9Settings> VP9_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vp9Settings").getter(VideoCodecSettings.getter(VideoCodecSettings::vp9Settings)).setter(VideoCodecSettings.setter(Builder::vp9Settings)).constructor(Vp9Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vp9Settings").build()}).build();
    private static final SdkField<XavcSettings> XAVC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XavcSettings").getter(VideoCodecSettings.getter(VideoCodecSettings::xavcSettings)).setter(VideoCodecSettings.setter(Builder::xavcSettings)).constructor(XavcSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AV1_SETTINGS_FIELD, AVC_INTRA_SETTINGS_FIELD, CODEC_FIELD, FRAME_CAPTURE_SETTINGS_FIELD, H264_SETTINGS_FIELD, H265_SETTINGS_FIELD, MPEG2_SETTINGS_FIELD, PRORES_SETTINGS_FIELD, UNCOMPRESSED_SETTINGS_FIELD, VC3_SETTINGS_FIELD, VP8_SETTINGS_FIELD, VP9_SETTINGS_FIELD, XAVC_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoCodecSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Av1Settings av1Settings;
    private final AvcIntraSettings avcIntraSettings;
    private final String codec;
    private final FrameCaptureSettings frameCaptureSettings;
    private final H264Settings h264Settings;
    private final H265Settings h265Settings;
    private final Mpeg2Settings mpeg2Settings;
    private final ProresSettings proresSettings;
    private final UncompressedSettings uncompressedSettings;
    private final Vc3Settings vc3Settings;
    private final Vp8Settings vp8Settings;
    private final Vp9Settings vp9Settings;
    private final XavcSettings xavcSettings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.av1Settings = builder.av1Settings;
        this.avcIntraSettings = builder.avcIntraSettings;
        this.codec = builder.codec;
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
        this.mpeg2Settings = builder.mpeg2Settings;
        this.proresSettings = builder.proresSettings;
        this.uncompressedSettings = builder.uncompressedSettings;
        this.vc3Settings = builder.vc3Settings;
        this.vp8Settings = builder.vp8Settings;
        this.vp9Settings = builder.vp9Settings;
        this.xavcSettings = builder.xavcSettings;
    }

    public final Av1Settings av1Settings() {
        return this.av1Settings;
    }

    public final AvcIntraSettings avcIntraSettings() {
        return this.avcIntraSettings;
    }

    public final VideoCodec codec() {
        return VideoCodec.fromValue(this.codec);
    }

    public final String codecAsString() {
        return this.codec;
    }

    public final FrameCaptureSettings frameCaptureSettings() {
        return this.frameCaptureSettings;
    }

    public final H264Settings h264Settings() {
        return this.h264Settings;
    }

    public final H265Settings h265Settings() {
        return this.h265Settings;
    }

    public final Mpeg2Settings mpeg2Settings() {
        return this.mpeg2Settings;
    }

    public final ProresSettings proresSettings() {
        return this.proresSettings;
    }

    public final UncompressedSettings uncompressedSettings() {
        return this.uncompressedSettings;
    }

    public final Vc3Settings vc3Settings() {
        return this.vc3Settings;
    }

    public final Vp8Settings vp8Settings() {
        return this.vp8Settings;
    }

    public final Vp9Settings vp9Settings() {
        return this.vp9Settings;
    }

    public final XavcSettings xavcSettings() {
        return this.xavcSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.av1Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.avcIntraSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.h265Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpeg2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.proresSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.uncompressedSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vc3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vp8Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vp9Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavcSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings)obj;
        return Objects.equals(this.av1Settings(), other.av1Settings()) && Objects.equals(this.avcIntraSettings(), other.avcIntraSettings()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.frameCaptureSettings(), other.frameCaptureSettings()) && Objects.equals(this.h264Settings(), other.h264Settings()) && Objects.equals(this.h265Settings(), other.h265Settings()) && Objects.equals(this.mpeg2Settings(), other.mpeg2Settings()) && Objects.equals(this.proresSettings(), other.proresSettings()) && Objects.equals(this.uncompressedSettings(), other.uncompressedSettings()) && Objects.equals(this.vc3Settings(), other.vc3Settings()) && Objects.equals(this.vp8Settings(), other.vp8Settings()) && Objects.equals(this.vp9Settings(), other.vp9Settings()) && Objects.equals(this.xavcSettings(), other.xavcSettings());
    }

    public final String toString() {
        return ToString.builder((String)"VideoCodecSettings").add("Av1Settings", (Object)this.av1Settings()).add("AvcIntraSettings", (Object)this.avcIntraSettings()).add("Codec", (Object)this.codecAsString()).add("FrameCaptureSettings", (Object)this.frameCaptureSettings()).add("H264Settings", (Object)this.h264Settings()).add("H265Settings", (Object)this.h265Settings()).add("Mpeg2Settings", (Object)this.mpeg2Settings()).add("ProresSettings", (Object)this.proresSettings()).add("UncompressedSettings", (Object)this.uncompressedSettings()).add("Vc3Settings", (Object)this.vc3Settings()).add("Vp8Settings", (Object)this.vp8Settings()).add("Vp9Settings", (Object)this.vp9Settings()).add("XavcSettings", (Object)this.xavcSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Av1Settings": {
                return Optional.ofNullable(clazz.cast(this.av1Settings()));
            }
            case "AvcIntraSettings": {
                return Optional.ofNullable(clazz.cast(this.avcIntraSettings()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "FrameCaptureSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureSettings()));
            }
            case "H264Settings": {
                return Optional.ofNullable(clazz.cast(this.h264Settings()));
            }
            case "H265Settings": {
                return Optional.ofNullable(clazz.cast(this.h265Settings()));
            }
            case "Mpeg2Settings": {
                return Optional.ofNullable(clazz.cast(this.mpeg2Settings()));
            }
            case "ProresSettings": {
                return Optional.ofNullable(clazz.cast(this.proresSettings()));
            }
            case "UncompressedSettings": {
                return Optional.ofNullable(clazz.cast(this.uncompressedSettings()));
            }
            case "Vc3Settings": {
                return Optional.ofNullable(clazz.cast(this.vc3Settings()));
            }
            case "Vp8Settings": {
                return Optional.ofNullable(clazz.cast(this.vp8Settings()));
            }
            case "Vp9Settings": {
                return Optional.ofNullable(clazz.cast(this.vp9Settings()));
            }
            case "XavcSettings": {
                return Optional.ofNullable(clazz.cast(this.xavcSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("av1Settings", AV1_SETTINGS_FIELD);
        map.put("avcIntraSettings", AVC_INTRA_SETTINGS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("frameCaptureSettings", FRAME_CAPTURE_SETTINGS_FIELD);
        map.put("h264Settings", H264_SETTINGS_FIELD);
        map.put("h265Settings", H265_SETTINGS_FIELD);
        map.put("mpeg2Settings", MPEG2_SETTINGS_FIELD);
        map.put("proresSettings", PRORES_SETTINGS_FIELD);
        map.put("uncompressedSettings", UNCOMPRESSED_SETTINGS_FIELD);
        map.put("vc3Settings", VC3_SETTINGS_FIELD);
        map.put("vp8Settings", VP8_SETTINGS_FIELD);
        map.put("vp9Settings", VP9_SETTINGS_FIELD);
        map.put("xavcSettings", XAVC_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoCodecSettings, T> g) {
        return obj -> g.apply((VideoCodecSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Av1Settings av1Settings;
        private AvcIntraSettings avcIntraSettings;
        private String codec;
        private FrameCaptureSettings frameCaptureSettings;
        private H264Settings h264Settings;
        private H265Settings h265Settings;
        private Mpeg2Settings mpeg2Settings;
        private ProresSettings proresSettings;
        private UncompressedSettings uncompressedSettings;
        private Vc3Settings vc3Settings;
        private Vp8Settings vp8Settings;
        private Vp9Settings vp9Settings;
        private XavcSettings xavcSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            this.av1Settings(model.av1Settings);
            this.avcIntraSettings(model.avcIntraSettings);
            this.codec(model.codec);
            this.frameCaptureSettings(model.frameCaptureSettings);
            this.h264Settings(model.h264Settings);
            this.h265Settings(model.h265Settings);
            this.mpeg2Settings(model.mpeg2Settings);
            this.proresSettings(model.proresSettings);
            this.uncompressedSettings(model.uncompressedSettings);
            this.vc3Settings(model.vc3Settings);
            this.vp8Settings(model.vp8Settings);
            this.vp9Settings(model.vp9Settings);
            this.xavcSettings(model.xavcSettings);
        }

        public final Av1Settings.Builder getAv1Settings() {
            return this.av1Settings != null ? this.av1Settings.toBuilder() : null;
        }

        public final void setAv1Settings(Av1Settings.BuilderImpl av1Settings) {
            this.av1Settings = av1Settings != null ? av1Settings.build() : null;
        }

        @Override
        public final Builder av1Settings(Av1Settings av1Settings) {
            this.av1Settings = av1Settings;
            return this;
        }

        public final AvcIntraSettings.Builder getAvcIntraSettings() {
            return this.avcIntraSettings != null ? this.avcIntraSettings.toBuilder() : null;
        }

        public final void setAvcIntraSettings(AvcIntraSettings.BuilderImpl avcIntraSettings) {
            this.avcIntraSettings = avcIntraSettings != null ? avcIntraSettings.build() : null;
        }

        @Override
        public final Builder avcIntraSettings(AvcIntraSettings avcIntraSettings) {
            this.avcIntraSettings = avcIntraSettings;
            return this;
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(VideoCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return this.frameCaptureSettings != null ? this.frameCaptureSettings.toBuilder() : null;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final H264Settings.Builder getH264Settings() {
            return this.h264Settings != null ? this.h264Settings.toBuilder() : null;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final H265Settings.Builder getH265Settings() {
            return this.h265Settings != null ? this.h265Settings.toBuilder() : null;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        @Override
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final Mpeg2Settings.Builder getMpeg2Settings() {
            return this.mpeg2Settings != null ? this.mpeg2Settings.toBuilder() : null;
        }

        public final void setMpeg2Settings(Mpeg2Settings.BuilderImpl mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings != null ? mpeg2Settings.build() : null;
        }

        @Override
        public final Builder mpeg2Settings(Mpeg2Settings mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings;
            return this;
        }

        public final ProresSettings.Builder getProresSettings() {
            return this.proresSettings != null ? this.proresSettings.toBuilder() : null;
        }

        public final void setProresSettings(ProresSettings.BuilderImpl proresSettings) {
            this.proresSettings = proresSettings != null ? proresSettings.build() : null;
        }

        @Override
        public final Builder proresSettings(ProresSettings proresSettings) {
            this.proresSettings = proresSettings;
            return this;
        }

        public final UncompressedSettings.Builder getUncompressedSettings() {
            return this.uncompressedSettings != null ? this.uncompressedSettings.toBuilder() : null;
        }

        public final void setUncompressedSettings(UncompressedSettings.BuilderImpl uncompressedSettings) {
            this.uncompressedSettings = uncompressedSettings != null ? uncompressedSettings.build() : null;
        }

        @Override
        public final Builder uncompressedSettings(UncompressedSettings uncompressedSettings) {
            this.uncompressedSettings = uncompressedSettings;
            return this;
        }

        public final Vc3Settings.Builder getVc3Settings() {
            return this.vc3Settings != null ? this.vc3Settings.toBuilder() : null;
        }

        public final void setVc3Settings(Vc3Settings.BuilderImpl vc3Settings) {
            this.vc3Settings = vc3Settings != null ? vc3Settings.build() : null;
        }

        @Override
        public final Builder vc3Settings(Vc3Settings vc3Settings) {
            this.vc3Settings = vc3Settings;
            return this;
        }

        public final Vp8Settings.Builder getVp8Settings() {
            return this.vp8Settings != null ? this.vp8Settings.toBuilder() : null;
        }

        public final void setVp8Settings(Vp8Settings.BuilderImpl vp8Settings) {
            this.vp8Settings = vp8Settings != null ? vp8Settings.build() : null;
        }

        @Override
        public final Builder vp8Settings(Vp8Settings vp8Settings) {
            this.vp8Settings = vp8Settings;
            return this;
        }

        public final Vp9Settings.Builder getVp9Settings() {
            return this.vp9Settings != null ? this.vp9Settings.toBuilder() : null;
        }

        public final void setVp9Settings(Vp9Settings.BuilderImpl vp9Settings) {
            this.vp9Settings = vp9Settings != null ? vp9Settings.build() : null;
        }

        @Override
        public final Builder vp9Settings(Vp9Settings vp9Settings) {
            this.vp9Settings = vp9Settings;
            return this;
        }

        public final XavcSettings.Builder getXavcSettings() {
            return this.xavcSettings != null ? this.xavcSettings.toBuilder() : null;
        }

        public final void setXavcSettings(XavcSettings.BuilderImpl xavcSettings) {
            this.xavcSettings = xavcSettings != null ? xavcSettings.build() : null;
        }

        @Override
        public final Builder xavcSettings(XavcSettings xavcSettings) {
            this.xavcSettings = xavcSettings;
            return this;
        }

        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoCodecSettings> {
        public Builder av1Settings(Av1Settings var1);

        default public Builder av1Settings(Consumer<Av1Settings.Builder> av1Settings) {
            return this.av1Settings((Av1Settings)((Av1Settings.Builder)Av1Settings.builder().applyMutation(av1Settings)).build());
        }

        public Builder avcIntraSettings(AvcIntraSettings var1);

        default public Builder avcIntraSettings(Consumer<AvcIntraSettings.Builder> avcIntraSettings) {
            return this.avcIntraSettings((AvcIntraSettings)((AvcIntraSettings.Builder)AvcIntraSettings.builder().applyMutation(avcIntraSettings)).build());
        }

        public Builder codec(String var1);

        public Builder codec(VideoCodec var1);

        public Builder frameCaptureSettings(FrameCaptureSettings var1);

        default public Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return this.frameCaptureSettings((FrameCaptureSettings)((FrameCaptureSettings.Builder)FrameCaptureSettings.builder().applyMutation(frameCaptureSettings)).build());
        }

        public Builder h264Settings(H264Settings var1);

        default public Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return this.h264Settings((H264Settings)((H264Settings.Builder)H264Settings.builder().applyMutation(h264Settings)).build());
        }

        public Builder h265Settings(H265Settings var1);

        default public Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return this.h265Settings((H265Settings)((H265Settings.Builder)H265Settings.builder().applyMutation(h265Settings)).build());
        }

        public Builder mpeg2Settings(Mpeg2Settings var1);

        default public Builder mpeg2Settings(Consumer<Mpeg2Settings.Builder> mpeg2Settings) {
            return this.mpeg2Settings((Mpeg2Settings)((Mpeg2Settings.Builder)Mpeg2Settings.builder().applyMutation(mpeg2Settings)).build());
        }

        public Builder proresSettings(ProresSettings var1);

        default public Builder proresSettings(Consumer<ProresSettings.Builder> proresSettings) {
            return this.proresSettings((ProresSettings)((ProresSettings.Builder)ProresSettings.builder().applyMutation(proresSettings)).build());
        }

        public Builder uncompressedSettings(UncompressedSettings var1);

        default public Builder uncompressedSettings(Consumer<UncompressedSettings.Builder> uncompressedSettings) {
            return this.uncompressedSettings((UncompressedSettings)((UncompressedSettings.Builder)UncompressedSettings.builder().applyMutation(uncompressedSettings)).build());
        }

        public Builder vc3Settings(Vc3Settings var1);

        default public Builder vc3Settings(Consumer<Vc3Settings.Builder> vc3Settings) {
            return this.vc3Settings((Vc3Settings)((Vc3Settings.Builder)Vc3Settings.builder().applyMutation(vc3Settings)).build());
        }

        public Builder vp8Settings(Vp8Settings var1);

        default public Builder vp8Settings(Consumer<Vp8Settings.Builder> vp8Settings) {
            return this.vp8Settings((Vp8Settings)((Vp8Settings.Builder)Vp8Settings.builder().applyMutation(vp8Settings)).build());
        }

        public Builder vp9Settings(Vp9Settings var1);

        default public Builder vp9Settings(Consumer<Vp9Settings.Builder> vp9Settings) {
            return this.vp9Settings((Vp9Settings)((Vp9Settings.Builder)Vp9Settings.builder().applyMutation(vp9Settings)).build());
        }

        public Builder xavcSettings(XavcSettings var1);

        default public Builder xavcSettings(Consumer<XavcSettings.Builder> xavcSettings) {
            return this.xavcSettings((XavcSettings)((XavcSettings.Builder)XavcSettings.builder().applyMutation(xavcSettings)).build());
        }
    }
}

