/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.TeletextPageType;
import software.amazon.awssdk.services.mediaconvert.model.___listOfTeletextPageTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TeletextDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TeletextDestinationSettings> {
    private static final SdkField<String> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageNumber").getter(TeletextDestinationSettings.getter(TeletextDestinationSettings::pageNumber)).setter(TeletextDestinationSettings.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageNumber").build()}).build();
    private static final SdkField<List<String>> PAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PageTypes").getter(TeletextDestinationSettings.getter(TeletextDestinationSettings::pageTypesAsStrings)).setter(TeletextDestinationSettings.setter(Builder::pageTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_NUMBER_FIELD, PAGE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TeletextDestinationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pageNumber;
    private final List<String> pageTypes;

    private TeletextDestinationSettings(BuilderImpl builder) {
        this.pageNumber = builder.pageNumber;
        this.pageTypes = builder.pageTypes;
    }

    public final String pageNumber() {
        return this.pageNumber;
    }

    public final List<TeletextPageType> pageTypes() {
        return ___listOfTeletextPageTypeCopier.copyStringToEnum(this.pageTypes);
    }

    public final boolean hasPageTypes() {
        return this.pageTypes != null && !(this.pageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> pageTypesAsStrings() {
        return this.pageTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPageTypes() ? this.pageTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeletextDestinationSettings)) {
            return false;
        }
        TeletextDestinationSettings other = (TeletextDestinationSettings)obj;
        return Objects.equals(this.pageNumber(), other.pageNumber()) && this.hasPageTypes() == other.hasPageTypes() && Objects.equals(this.pageTypesAsStrings(), other.pageTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TeletextDestinationSettings").add("PageNumber", (Object)this.pageNumber()).add("PageTypes", this.hasPageTypes() ? this.pageTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
            case "PageTypes": {
                return Optional.ofNullable(clazz.cast(this.pageTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageNumber", PAGE_NUMBER_FIELD);
        map.put("pageTypes", PAGE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TeletextDestinationSettings, T> g) {
        return obj -> g.apply((TeletextDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pageNumber;
        private List<String> pageTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TeletextDestinationSettings model) {
            this.pageNumber(model.pageNumber);
            this.pageTypesWithStrings(model.pageTypes);
        }

        public final String getPageNumber() {
            return this.pageNumber;
        }

        public final void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final Collection<String> getPageTypes() {
            if (this.pageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pageTypes;
        }

        public final void setPageTypes(Collection<String> pageTypes) {
            this.pageTypes = ___listOfTeletextPageTypeCopier.copy(pageTypes);
        }

        @Override
        public final Builder pageTypesWithStrings(Collection<String> pageTypes) {
            this.pageTypes = ___listOfTeletextPageTypeCopier.copy(pageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageTypesWithStrings(String ... pageTypes) {
            this.pageTypesWithStrings(Arrays.asList(pageTypes));
            return this;
        }

        @Override
        public final Builder pageTypes(Collection<TeletextPageType> pageTypes) {
            this.pageTypes = ___listOfTeletextPageTypeCopier.copyEnumToString(pageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageTypes(TeletextPageType ... pageTypes) {
            this.pageTypes(Arrays.asList(pageTypes));
            return this;
        }

        public TeletextDestinationSettings build() {
            return new TeletextDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TeletextDestinationSettings> {
        public Builder pageNumber(String var1);

        public Builder pageTypesWithStrings(Collection<String> var1);

        public Builder pageTypesWithStrings(String ... var1);

        public Builder pageTypes(Collection<TeletextPageType> var1);

        public Builder pageTypes(TeletextPageType ... var1);
    }
}

