/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ColorCorrector;
import software.amazon.awssdk.services.mediaconvert.model.Deinterlacer;
import software.amazon.awssdk.services.mediaconvert.model.ImageInserter;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducer;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeBurnin;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoPreprocessor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoPreprocessor> {
    private static final SdkField<ColorCorrector> COLOR_CORRECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoPreprocessor.getter(VideoPreprocessor::colorCorrector)).setter(VideoPreprocessor.setter(Builder::colorCorrector)).constructor(ColorCorrector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorCorrector").build()}).build();
    private static final SdkField<Deinterlacer> DEINTERLACER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoPreprocessor.getter(VideoPreprocessor::deinterlacer)).setter(VideoPreprocessor.setter(Builder::deinterlacer)).constructor(Deinterlacer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deinterlacer").build()}).build();
    private static final SdkField<ImageInserter> IMAGE_INSERTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoPreprocessor.getter(VideoPreprocessor::imageInserter)).setter(VideoPreprocessor.setter(Builder::imageInserter)).constructor(ImageInserter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageInserter").build()}).build();
    private static final SdkField<NoiseReducer> NOISE_REDUCER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoPreprocessor.getter(VideoPreprocessor::noiseReducer)).setter(VideoPreprocessor.setter(Builder::noiseReducer)).constructor(NoiseReducer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noiseReducer").build()}).build();
    private static final SdkField<TimecodeBurnin> TIMECODE_BURNIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoPreprocessor.getter(VideoPreprocessor::timecodeBurnin)).setter(VideoPreprocessor.setter(Builder::timecodeBurnin)).constructor(TimecodeBurnin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurnin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_CORRECTOR_FIELD, DEINTERLACER_FIELD, IMAGE_INSERTER_FIELD, NOISE_REDUCER_FIELD, TIMECODE_BURNIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final ColorCorrector colorCorrector;
    private final Deinterlacer deinterlacer;
    private final ImageInserter imageInserter;
    private final NoiseReducer noiseReducer;
    private final TimecodeBurnin timecodeBurnin;

    private VideoPreprocessor(BuilderImpl builder) {
        this.colorCorrector = builder.colorCorrector;
        this.deinterlacer = builder.deinterlacer;
        this.imageInserter = builder.imageInserter;
        this.noiseReducer = builder.noiseReducer;
        this.timecodeBurnin = builder.timecodeBurnin;
    }

    public ColorCorrector colorCorrector() {
        return this.colorCorrector;
    }

    public Deinterlacer deinterlacer() {
        return this.deinterlacer;
    }

    public ImageInserter imageInserter() {
        return this.imageInserter;
    }

    public NoiseReducer noiseReducer() {
        return this.noiseReducer;
    }

    public TimecodeBurnin timecodeBurnin() {
        return this.timecodeBurnin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorCorrector());
        hashCode = 31 * hashCode + Objects.hashCode(this.deinterlacer());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(this.noiseReducer());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeBurnin());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoPreprocessor)) {
            return false;
        }
        VideoPreprocessor other = (VideoPreprocessor)obj;
        return Objects.equals(this.colorCorrector(), other.colorCorrector()) && Objects.equals(this.deinterlacer(), other.deinterlacer()) && Objects.equals(this.imageInserter(), other.imageInserter()) && Objects.equals(this.noiseReducer(), other.noiseReducer()) && Objects.equals(this.timecodeBurnin(), other.timecodeBurnin());
    }

    public String toString() {
        return ToString.builder((String)"VideoPreprocessor").add("ColorCorrector", (Object)this.colorCorrector()).add("Deinterlacer", (Object)this.deinterlacer()).add("ImageInserter", (Object)this.imageInserter()).add("NoiseReducer", (Object)this.noiseReducer()).add("TimecodeBurnin", (Object)this.timecodeBurnin()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorCorrector": {
                return Optional.ofNullable(clazz.cast(this.colorCorrector()));
            }
            case "Deinterlacer": {
                return Optional.ofNullable(clazz.cast(this.deinterlacer()));
            }
            case "ImageInserter": {
                return Optional.ofNullable(clazz.cast(this.imageInserter()));
            }
            case "NoiseReducer": {
                return Optional.ofNullable(clazz.cast(this.noiseReducer()));
            }
            case "TimecodeBurnin": {
                return Optional.ofNullable(clazz.cast(this.timecodeBurnin()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoPreprocessor, T> g) {
        return obj -> g.apply((VideoPreprocessor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColorCorrector colorCorrector;
        private Deinterlacer deinterlacer;
        private ImageInserter imageInserter;
        private NoiseReducer noiseReducer;
        private TimecodeBurnin timecodeBurnin;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoPreprocessor model) {
            this.colorCorrector(model.colorCorrector);
            this.deinterlacer(model.deinterlacer);
            this.imageInserter(model.imageInserter);
            this.noiseReducer(model.noiseReducer);
            this.timecodeBurnin(model.timecodeBurnin);
        }

        public final ColorCorrector.Builder getColorCorrector() {
            return this.colorCorrector != null ? this.colorCorrector.toBuilder() : null;
        }

        @Override
        public final Builder colorCorrector(ColorCorrector colorCorrector) {
            this.colorCorrector = colorCorrector;
            return this;
        }

        public final void setColorCorrector(ColorCorrector.BuilderImpl colorCorrector) {
            this.colorCorrector = colorCorrector != null ? colorCorrector.build() : null;
        }

        public final Deinterlacer.Builder getDeinterlacer() {
            return this.deinterlacer != null ? this.deinterlacer.toBuilder() : null;
        }

        @Override
        public final Builder deinterlacer(Deinterlacer deinterlacer) {
            this.deinterlacer = deinterlacer;
            return this;
        }

        public final void setDeinterlacer(Deinterlacer.BuilderImpl deinterlacer) {
            this.deinterlacer = deinterlacer != null ? deinterlacer.build() : null;
        }

        public final ImageInserter.Builder getImageInserter() {
            return this.imageInserter != null ? this.imageInserter.toBuilder() : null;
        }

        @Override
        public final Builder imageInserter(ImageInserter imageInserter) {
            this.imageInserter = imageInserter;
            return this;
        }

        public final void setImageInserter(ImageInserter.BuilderImpl imageInserter) {
            this.imageInserter = imageInserter != null ? imageInserter.build() : null;
        }

        public final NoiseReducer.Builder getNoiseReducer() {
            return this.noiseReducer != null ? this.noiseReducer.toBuilder() : null;
        }

        @Override
        public final Builder noiseReducer(NoiseReducer noiseReducer) {
            this.noiseReducer = noiseReducer;
            return this;
        }

        public final void setNoiseReducer(NoiseReducer.BuilderImpl noiseReducer) {
            this.noiseReducer = noiseReducer != null ? noiseReducer.build() : null;
        }

        public final TimecodeBurnin.Builder getTimecodeBurnin() {
            return this.timecodeBurnin != null ? this.timecodeBurnin.toBuilder() : null;
        }

        @Override
        public final Builder timecodeBurnin(TimecodeBurnin timecodeBurnin) {
            this.timecodeBurnin = timecodeBurnin;
            return this;
        }

        public final void setTimecodeBurnin(TimecodeBurnin.BuilderImpl timecodeBurnin) {
            this.timecodeBurnin = timecodeBurnin != null ? timecodeBurnin.build() : null;
        }

        public VideoPreprocessor build() {
            return new VideoPreprocessor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoPreprocessor> {
        public Builder colorCorrector(ColorCorrector var1);

        default public Builder colorCorrector(Consumer<ColorCorrector.Builder> colorCorrector) {
            return this.colorCorrector((ColorCorrector)((ColorCorrector.Builder)ColorCorrector.builder().applyMutation(colorCorrector)).build());
        }

        public Builder deinterlacer(Deinterlacer var1);

        default public Builder deinterlacer(Consumer<Deinterlacer.Builder> deinterlacer) {
            return this.deinterlacer((Deinterlacer)((Deinterlacer.Builder)Deinterlacer.builder().applyMutation(deinterlacer)).build());
        }

        public Builder imageInserter(ImageInserter var1);

        default public Builder imageInserter(Consumer<ImageInserter.Builder> imageInserter) {
            return this.imageInserter((ImageInserter)((ImageInserter.Builder)ImageInserter.builder().applyMutation(imageInserter)).build());
        }

        public Builder noiseReducer(NoiseReducer var1);

        default public Builder noiseReducer(Consumer<NoiseReducer.Builder> noiseReducer) {
            return this.noiseReducer((NoiseReducer)((NoiseReducer.Builder)NoiseReducer.builder().applyMutation(noiseReducer)).build());
        }

        public Builder timecodeBurnin(TimecodeBurnin var1);

        default public Builder timecodeBurnin(Consumer<TimecodeBurnin.Builder> timecodeBurnin) {
            return this.timecodeBurnin((TimecodeBurnin)((TimecodeBurnin.Builder)TimecodeBurnin.builder().applyMutation(timecodeBurnin)).build());
        }
    }
}

